#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: UtilsTest.py 14639 2024-07-02 07:31:07Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-07-02 15:31:07 +0800 (週二, 02 七月 2024) $
# $Revision: 14639 $

import unittest
from wasm_file_http.utils import isUrlAllowed

class TestIsUrlAllowed(unittest.TestCase):
    def test_url_allowed(self):
        url = "http://localhost:8000/api/task-configs/5/execute/"
        allowedURLs = ["localhost:8000/api/task-configs/*"]
        self.assertTrue(isUrlAllowed(url, allowedURLs), "Test case 1 failed")  # Output: True

        allowedURLs = ["localhost:8000/api/*"]
        self.assertTrue(isUrlAllowed(url, allowedURLs), "Test case 2 failed")  # Output: True

        allowedURLs = ["*"]
        self.assertTrue(isUrlAllowed(url, allowedURLs), "Test case 3 failed")  # Output: True

        allowedURLs = ["localhost"]
        self.assertTrue(isUrlAllowed(url, allowedURLs), "Test case 4 failed")  # Output: True

        allowedURLs = ["localhost:8000/api/mailbox"]
        self.assertFalse(isUrlAllowed(url, allowedURLs), "Test case 5 failed")  # Output: True

        allowedURLs = ["route.com"]
        self.assertFalse(isUrlAllowed(url, allowedURLs), "Test case 6 failed")  # Output: True

        allowedURLs = ["http://localhost:8000/api/task-configs/*/dummy/"]
        self.assertFalse(isUrlAllowed(url, allowedURLs), "Test case 7 failed")  # Output: True

if __name__ == "__main__":
    unittest.main()
