#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Exceptions.py 14748 2024-07-25 06:15:52Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-07-25 14:15:52 +0800 (週四, 25 七月 2024) $
# $Revision: 14748 $

class WasmPatchingException(Exception):
    """Exception raised for errors during the WASM patching process."""
    def __init__(
            self,
            message="An error occurred during WASM complilation. You should note that the tool you are using is based on wasi-sdk to convert to .wasm files. Refer to https://github.com/WebAssembly/wasi-sdk",
            errors=None
        ):
        super().__init__(message)
        self.errors = errors

class WorkspaceSizeLimitExceededException(Exception):
    """Exception raised when the folder size exceeds the specified limit."""
    def __init__(self, message="Folder size has reached the limit.", errors=None):
        super().__init__(message)
        self.errors = errors

class WorkspaceFileCountLimitExceededException(Exception):
    """Exception raised when the folder file count exceeds the specified limit."""
    def __init__(self, message="Folder file count has reached the limit.", errors=None):
        super().__init__(message)
        self.errors = errors
