#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Handlers.py 14741 2024-07-22 07:48:25Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-07-22 15:48:25 +0800 (週一, 22 七月 2024) $
# $Revision: 14741 $

import os
from .Exceptions import WorkspaceFileCountLimitExceededException, WorkspaceSizeLimitExceededException

class FileLimitHandler:
    def __init__(self, directory, maxSize, maxFiles=1000):
        self.directory = directory
        self.maxSize = maxSize
        self.maxFiles = maxFiles

    def check(self, data):
        if self._getDirectorySize() + len(data) > self.maxSize:
            raise WorkspaceSizeLimitExceededException(message=f"workspace file size has reached limit of {self.maxSize / 1024 / 1024} MB")
        if self._getFileCount() >= self.maxFiles:
            raise WorkspaceFileCountLimitExceededException(message=f"workspace file count has reached limit of {self.maxFiles} files")
        return # Writing allowed

    def _getDirectorySize(self):
        totalSize = 0
        for dirpath, dirnames, filenames in os.walk(self.directory):
            for f in filenames:
                fp = os.path.join(dirpath, f)
                totalSize += os.path.getsize(fp)
        return totalSize

    def _getFileCount(self):
        return len([f for f in os.listdir(self.directory) if os.path.isfile(os.path.join(self.directory, f))])
