#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Wasm2wat.py 14845 2024-08-12 10:03:59Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-08-12 18:03:59 +0800 (週一, 12 八月 2024) $
# $Revision: 14845 $

import subprocess
import os
import logging
from typing import Tuple

logger = logging.getLogger(__name__)

def generateWATByWasmFile(wasmFilePath: str, wabtPath: str, timeout: int=180) -> Tuple[bool, str]:

    """
        https://github.com/WebAssembly/wabt

        generate .wat from .wasm using wasm2wat
        return True and the file path if file is successfully generated
    """

    generatedFilePath = os.path.join(os.path.dirname(wasmFilePath), "original.wat")

    # funcFilePath = os.path.abspath(__file__)
    # WABT_PATH = os.path.join(os.path.dirname(funcFilePath), "wabt")

    command = [
        os.path.join(wabtPath, "bin", "wasm2wat"),
        wasmFilePath,
        "-o",
        generatedFilePath
    ]

    # TODO: 直接拿執行檔 COMMIT 上去 簡單些

    process = subprocess.run(command, capture_output=True, text=True, timeout=timeout, check=False)

    # Check the process
    logger.debug("result of generating WAT from WASM file:")
    logger.debug(f"Return code: {process.returncode}")
    logger.debug(f"Output: {process.stdout}")
    logger.debug(f"Error (if any): {process.stderr}")

    if process.returncode == 0:
        return True, generatedFilePath
    else:
        return False, None

def generateWasmByWatFile(
        watFilePath: str,
        wabtPath: str,
        outputFileName: str,
        outputDir: str | None = None,
        timeout: int = 180
    ) -> Tuple[bool, str]:

    """
        https://github.com/WebAssembly/wabt

        generate .wasm from .wat using wat2wasm
        return True and the file path if file is successfully generated
    """

    if outputDir is None:
        generatedFilePath = os.path.join(os.path.dirname(watFilePath), outputFileName)
    else:
        generatedFilePath = os.path.join(outputDir, outputFileName)

    # funcFilePath = os.path.abspath(__file__)
    # WABT_PATH = os.path.join(os.path.dirname(funcFilePath), "wabt")

    command = [
        os.path.join(wabtPath, "bin", "wat2wasm"),
        watFilePath,
        "-o",
        generatedFilePath
    ]

    # TODO: 直接拿執行檔 COMMIT 上去 簡單些

    process = subprocess.run(command, capture_output=True, text=True, timeout=timeout, check=False)

    # Check the process
    logger.debug("result of generating WAT from WASM file:")
    logger.debug(f"Return code: {process.returncode}")
    logger.debug(f"Output: {process.stdout}")
    logger.debug(f"Error (if any): {process.stderr}")

    if process.returncode == 0:
        return True, generatedFilePath
    else:
        return False, None

if __name__ == "__main__":

    # for Linux
    generateWATByWasmFile(
        wasmFilePath=r"/mnt/c/Users/Tim/Desktop/nuwa/Mercurius/Pixiu/Products/Aristotle/ProxyAPI/tests/fixtures/data/testcase2/Main.wasm",
    )

    generateWasmByWatFile(
        watFilePath=r"/mnt/c/Users/Tim/Desktop/nuwa/Mercurius/Pixiu/Products/Aristotle/ProxyAPI/tests/fixtures/data/testcase2/Main.wasm",
    )
