#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

from django.utils.http import urlquote  as django_urlquote
from django.utils.translation import override as force_language
from django.utils.translation import ugettext_lazy as _

from cms.toolbar_pool import toolbar_pool
from cms.utils.conf import get_cms_setting
from cms import cms_toolbars

class PageToolbar2(cms_toolbars.PageToolbar):
    def add_structure_mode_item(self, 
        extra_classes=('cms-toolbar-item-cms-mode-switcher',)):
        self.toolbar.request_path = django_urlquote(self.toolbar.request_path)
        return super(PageToolbar2, self).add_structure_mode_item(
                extra_classes=extra_classes)
                    
toolbar_pool.toolbars['cms.cms_toolbars.PageToolbar'] = PageToolbar2


