#!/bin/sh

if [ -z $CONDA_DEFAULT_ENV ]; then
    conda create -p env python=3.9 -y
    source env/bin/activate
    python -m pip install --upgrade pip
    pip install -r REQUIREMENTS.txt
fi

python manage.py migrate --noinput
if [[ $? -ne 0 ]] ; then
    # Unknown why (not investigate yet), MySQL will complain foreign key 
    # constrain error on first time migrate, so we migrate twice if needed.
    python manage.py migrate --noinput
fi
python manage.py collectstatic --noinput

# load initial data and set default settings when run the project first.
python manage.py deploy configure