#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import os
import sys
import requests
import subprocess

from lxml import etree

from django.http import HttpResponse, JsonResponse
from django.views.decorators.csrf import csrf_exempt
from django.conf import settings

from Iuno.Version import IUNO_VERSION

REPORT_PATH = os.path.join("tests", "test-reports")

def getTestcaseReport():
    for log in os.listdir(REPORT_PATH):
        if log.endswith(".xml") and log.startswith("TEST"):
            logPath = os.path.join(REPORT_PATH, log)
            tree = etree.parse(logPath)
            
            allData = []
            
            for testcase in tree.iter(tag='testcase'):
                data = {
                    'classname': testcase.get("classname", None),
                    'name': testcase.get("name", None),
                    'time': testcase.get("time", None),
                    'error': [],
                }
                for error in testcase.iter(tag='error'):
                    e = {
                        'message': error.get("message", None),
                        'type': error.get("type", None),
                        'traceback': error.text,
                    }
                    data['error'].append(e)
                    
                allData.append(data)
                
            return allData

@csrf_exempt
def test(request):
    if request.POST.get("password") == "25025529":
        env = os.environ.copy()
        env.pop('DJANGO_SETTINGS_MODULE', None)
        env.pop("HTTPS", None)
        
        if request.POST.get("settings"):
            
            resultCode = subprocess.call(
                "python manage.py testall --settings %s > test.log" % request.POST.get("settings"), shell=True, env=env)
        else:
            resultCode = subprocess.call(
                "python manage.py testall > test.log", shell=True, env=env)
        
        with open("test.log", "r") as f:
            result = f.read()
            
        track = getTestcaseReport()
            
        data = {
            'APP_VERSION': getattr(settings, "APP_VERSION", None),
            'IUNO_VERSION': IUNO_VERSION,
            'result': result,
            'resultCode': resultCode,
            'track': track,
        }
        
        return JsonResponse(data)
    return HttpResponse("success")