#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Util.py 9427 2015-09-15 08:01:29Z Judy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $ (last)
# $Date: 2015-09-15 16:01:29 +0800 (週二, 15 九月 2015) $
# $Revision: 9427 $

import sys
import traceback

def getExceptionStack(e):
    """
    Get Stack for error exception.

    @param e Error exception.
    """
    c = '\n'.join(traceback.format_tb(sys.exc_info()[-1]))
    return '%s\n%s\n' % (c, e)
