#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10932 2018-03-26 07:56:30Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-03-26 15:56:30 +0800 (週一, 26 三月 2018) $
# $Revision: 10932 $

from django.template import Context

def _toDict(d):
    """
    Convert context instance to dictionary.

    @param d Context instance or dictionary.
    @return Dictionary instance.
    """
    if isinstance(d, Context):
        dic = {}
        # If a.html extends b.html, the context.dicts[1] => b.html's context,
        # context.dicts[0] => a.html's context.
        for dd in reversed(d.dicts):
            dic.update(dd)
        return dic

    if isinstance(d, dict):
        return d
    else:
        raise TypeError

from django.utils.html import escape

def flatParamsToQueryString(params):
    """
    Convert a dictionary value to a single string.
    The returned string will contain a leading space followed by &key=value,
    XML-style pairs. It is assumed that the keys do not need to be XML-escaped.
    If the passed dictionary is empty, then return an empty string.

    @param params Dictionary instance.
    @return Flatten value if the passed dictionary has value.
    """
    return ''.join(['&%s=%s' % (k, escape(v)) for k, v in list(params.items())
                     if not k.startswith('_')])
