#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: MyI18nTest.py 11265 2018-11-23 05:42:44Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-23 13:42:44 +0800 (週五, 23 十一月 2018) $
# $Revision: 11265 $
#
# Contributors:
#  Jumann (original author)
#  Bear

# from Iuppiter import DjangoEmbed
from Iuppiter import test as TestUtil

import unittest
import django

from django.test.client import Client

TestUtil.chdirToRootDir()

import Iuppiter.tests


class MyI18nTest(unittest.TestCase):
    """
    Test case for MyI18n.    """

    def setUp(self):
        self.client = Client()

    def testLanguagesTag(self):
        urlpatterns = Iuppiter.tests.urlpatterns

        from Iuppiter.extension.views import view

        @view('DefaultUrlLang.html')
        def testDefaultSetting(request):
            return {}

        @view('CustmizeUrlLang.html')
        def testCusumizeSetting(request):
            return {}

        defaultUrl = '/test/default/'
        customizeUrl = '/test/customize/'

        if django.__version__ == '1.8':
            from django.conf.urls import patterns

            urlpatterns += patterns('',
                (r'^%s$' % defaultUrl[1:], testDefaultSetting),
                (r'^%s$' % customizeUrl[1:], testCusumizeSetting),)
        else:
            from django.conf.urls import url

            urlpatterns += (
                url(r'^%s$' % defaultUrl[1:], testDefaultSetting),
                url(r'^%s$' % customizeUrl[1:], testCusumizeSetting),)

        response = self.client.post(defaultUrl)
        self.assertTrue(response.content.find(b'/i18n/setlang/') > -1)

        response = self.client.post(customizeUrl)
        self.assertTrue(response.content.find(b'/testApp/testUrl/') > -1)

if __name__ == '__main__':
    unittest.main()
