#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 1109 2021-07-03 04:56:23Z Casey $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $ (last)
# $Date: 2021-07-03 12:56:23 +0800 (週六, 03 七月 2021) $
# $Revision: 1109 $

import os
import sys
import six
import json
import datetime
import re

import requests

from Crypto.PublicKey import RSA

from decorator import decorator
from termcolor import colored, cprint
from fabric import task
from fabric import Connection as _Connection
from fabric import connection
from fabric.connection import opens

# patch
from invoke.runners import Runner

DEFAULT_MARIADB_PASSOWRD = os.environ.get(
    'DEFAULT_MARIADB_PASSOWRD', "SuXeMA3oTeXWgfjz2G1BGrPm0v0OKw")

DEPLOY_TEST_SERVER_DOMAIN = os.environ.get(
    'DEPLOY_TEST_SERVER_DOMAIN', 'test.nuwainfo.com')
DEPLOY_TEST_SITE_DOMAIN = os.environ.get(
    'DEPLOY_TEST_SITE_DOMAIN', 'scaffold.nuwainfo.com')

DEPLOY_TEST_SERVER_USER = os.environ.get(
    'DEPLOY_TEST_SERVER_USER', 'nuwa')
DEPLOY_TEST_SERVER_PASSWORD = os.environ.get(
    'DEPLOY_TEST_SERVER_PASSWORD', '@%)@5529')

_read_our_stdin = Runner.read_our_stdin

def read_our_stdin(self, input_):
    bytes_ = _read_our_stdin(self, input_)
    if bytes_:
        return bytes_
    else:
        return None

Runner.read_our_stdin = read_our_stdin

def getBuildData(shPath, dataName):
    with open(shPath, 'r') as f:
        for line in f.readlines():
            if ("%s=" % dataName in line) and ("#" not in line.lstrip()):
                index = line.index("=") + 1
                return line[index:].replace('\r\n', '').strip()
    return None

def showSplash():
    import pyfiglet
    cprint("-" * 79, "white", attrs=["bold"],)
    cprint(pyfiglet.figlet_format('Nuwa Info', font="standard"),
           "blue", attrs=["bold"],)

    cprint(pyfiglet.figlet_format('Deploy', font="standard"),
           "yellow", attrs=["bold"],)
    cprint("-" * 79, "white", attrs=["bold"],)

    if six.PY2:
        cprint(
            "Deploy is only run by python3.",
            "blue",
            "on_white",
            attrs=["bold", "underline"],
        )
        sys.exit()
    else:
        cprint(
            colored(
                "When enter the shell, "
                "you must press Enter twice to execute command.",
                "yellow"
            )
        )
        
def getConnectKwargs(password=None, key=os.path.join("PrivateKey.key")):
    # put key
    if password:
        return {"password": password,}
    else:
        if os.path.exists(key):
            return {"key_filename": key,}
        else:
            return None

def getOrCreateKey(username, keyPath=os.path.join("Keys")):
    if not os.path.exists(keyPath):
        os.mkdir(keyPath)
    userPath = os.path.join(keyPath, username)
    privateKeyPath = os.path.join(userPath, "PrivateKey.key")
    publicKeyPath = os.path.join(userPath, "PublicKey.key")

    # check key
    if os.path.isdir(userPath):
        # get key
        with open(publicKeyPath, 'r') as f:
            publicKey = f.read()
        with open(privateKeyPath, 'r') as f:
            privateKey = f.read()
    else:
        # make key
        os.mkdir(userPath)

        key = RSA.generate(4096)

        publicKey = key.publickey().exportKey('OpenSSH').decode("utf-8")
        privateKey = key.exportKey("PEM").decode("utf-8")

        with open(publicKeyPath, 'w') as f:

            f.write(publicKey)

        with open(privateKeyPath, 'w') as f:
            privateKey = privateKey.replace(
                "BEGIN PRIVATE KEY", "BEGIN RSA PRIVATE KEY")
            privateKey = privateKey.replace(
                "END PRIVATE KEY", "END RSA PRIVATE KEY")

            f.write(privateKey)


    return (publicKey, privateKey, publicKeyPath, privateKeyPath)

@decorator
def record(func, c, *args, **kwargs):
    rt = None
    try:
        rt = func(c, *args, **kwargs)
    except Exception as e:
        cprint(
            colored(
                "ERROR: %s" % str(e),
                "red"
            )
        )
        c.addLog("ERROR: %s" % str(e))
        raise
    finally:
        c.recordLogs()

    return rt

# patch
@opens
def run(self, command, notRecord=False, **kwargs):
    """
    Execute a shell command on the remote end of this connection.

    This method wraps an SSH-capable implementation of
    `invoke.runners.Runner.run`; see its documentation for details.

    .. warning::
        There are a few spots where Fabric departs from Invoke's default
        settings/behaviors; they are documented under
        `.Config.global_defaults`.

    .. versionadded:: 2.0
    """
    if "hide" in kwargs and kwargs["hide"] == True:
        pass
    else:
        cprint(
            command,
            "blue",
            "on_white",
            attrs=["bold", "underline"],
        )

    if six.PY2 and not kwargs.get("pty"):
        kwargs["hide"] = True

    if not notRecord:
        c = "%s: %s" % (command, str(datetime.datetime.now().time()))
        if hasattr(self, "commands"):
            self.commands.append(c)
        else:
            self.commands = [c]

    if not "encoding" in kwargs:
        kwargs["encoding"] = "utf8"

    # with open("test.log", 'a+') as f:
        # result = self._run(self._remote_runner(), command, out_stream=f, err_stream=f, **kwargs)
    result = self._run(self._remote_runner(), command, **kwargs)

    return result

def recordLogs(self):
    # get user
    if "key_filename" in self.connect_kwargs:
        from Crypto.PublicKey import RSA

        with open(self.connect_kwargs["key_filename"], "r") as f:
            key = RSA.import_key(f.read())

        publicKey = key.publickey().exportKey('OpenSSH').decode("utf-8")

        result = self.run(
            "cat ~/.ssh/authorized_keys | grep '%s'" % publicKey,
            hide=True, notRecord=True)
        result = result.stdout
        username = re.findall(r"USERNAME=(\w+)", result)[0]
    else:
        username = "someone"

    # get ip
    # request https://api.ipify.org/?format=json to get ip
    try:
        ip = requests.get("https://api.ipify.org/?format=json")
        ip = json.loads(ip.text)
    except Exception as e:
        ip = {}
    finally:
        username = "%s(%s)" % (username, ip.get("ip", "unknown"))

    # 跳脫
    commands = [cmd.replace("'", "'\\''") for cmd in self.commands]

    # record
    date = datetime.datetime.now().date()
    msg = "Execute command by %s at %s" % (username, date)
    logs = (
        "-----%s-----"
        "\\n%s\\n"
        "-----%s-----\\n") % (
            msg, "\\n".join(commands), "-" * len(msg))
    cmd = "echo -e '%s' >> ~/.deploy_history" % logs
    self.run(cmd, hide=True, notRecord=True)

    # clean
    self.commands = []

    return

def addLog(self, log):
    log = "%s: %s" % (log, str(datetime.datetime.now().time()))
    if hasattr(self, 'commands'):
        self.commands.append(log)
    else:
        self.commands = [log,]

connection.Connection.run = run
connection.Connection.addLog = addLog
connection.Connection.recordLogs = recordLogs

def unixPath(*args):
    return os.path.join(*args).replace("\\", "/")

def prompt(msg):
    if six.PY2:
        result = raw_input(msg)
    else:
        result = input(msg)
    return result

def utf8(s, encodings=None, throw=True):
    """
    Convert a string (UNICODE or ANSI) to a utf8 string.

    @param s String.
    @param encodings Native encodings for decode. It will be tried to decode
                     string, try and error.
    @param throw Raise exception if it fails to convert string.
    @return UTF8 string.
    """
    if isinstance(s, six.text_type):
        return s.encode('utf-8')
    else:
        return _unicode(s, encodings=encodings, throw=throw).encode('utf-8')

def configureDjango(*args, **kws):
    """
    Configure django settings by given arguments.

    @param *args Arguments.
    @param **kws Keyword arguments.
    """
    import django.template.loader
    from django.conf import settings as djangoSettings
    from django.utils.functional import empty

    djangoSettings._wrapped = empty
    djangoSettings.configure(*args, **kws)

    django.setup()
