#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11660 2019-07-21 13:24:58Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2019-07-21 21:24:58 +0800 (週日, 21 七月 2019) $
# $Revision: 11660 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class Settings(object):

    CALL_TO_ACTION_DEFAULT_TEMPLATE = \
        "blog_extension/call_to_action/Default.html"

    CALL_TO_ACTION_TEMPLATES = [
        (CALL_TO_ACTION_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'CALL_TO_ACTION_TEMPLATES'):
        for ele in _settings.CALL_TO_ACTION_TEMPLATES:
            if not ele[0] == "blog_extension/call_to_action/Default.html":
                CALL_TO_ACTION_TEMPLATES.append(ele)

    CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE = \
        "blog_extension/call_to_action/DefaultForm.html"

    CALL_TO_ACTION_FORM_TEMPLATES = [
        (CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'CALL_TO_ACTION_FORM_TEMPLATES'):
        for ele in _settings.CALL_TO_ACTION_FORM_TEMPLATES:
            if not ele[0] == "blog_extension/call_to_action/DefaultForm.html":
                CALL_TO_ACTION_FORM_TEMPLATES.append(ele)

    # add call to action form template in to form tmeplates
    # if 'DJANGOCMS_FORMS_TEMPLATES' in _settings:
    #     formTemplates = settingsDict['DJANGOCMS_FORMS_TEMPLATES']
    # else:
    #     formTemplates = LANDING_FORM_SETTINGS

    formTemplates = _settings.DJANGOCMS_FORMS_TEMPLATES
    # print(CALL_TO_ACTION_FORM_TEMPLATES)
    filteredTemplates = [t for t in CALL_TO_ACTION_FORM_TEMPLATES  if t not in _settings.DJANGOCMS_FORMS_TEMPLATES]
    
    _settings.DJANGOCMS_FORMS_TEMPLATES = formTemplates + filteredTemplates
    

settings = Settings()
