from django.contrib import admin

# Register your models here.
from action.models import CallToActionStatistics

# @admin.register(CallToActionStatistics, CallToActionStatisticsAdmin)
class CallToActionStatisticsAdmin(admin.ModelAdmin):
    fields = ('url', 'email', 'count', 'token')
    list_display = ('url', 'email', 'count', 'token')
    ordering = ['url', 'count']
    search_fields = ('url', 'email')
admin.site.register(CallToActionStatistics, CallToActionStatisticsAdmin)