from djangocms_forms.cms_plugins import FormFieldInline
from djangocms_forms.models import FormDefinition
# from djangocms_file.cms_plugins import FilePlugin
from django.contrib import admin
from django.utils.translation import ugettext as _
from django.conf import settings
from django.template.loader import select_template
from djangocms_forms.utils import int_to_hashid

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool

from action.models import CallToActionModel
from action import settings as actionSettings

# from djangocms_file.models import File
from djangocms_forms.cms_plugins import FormPlugin
from djangocms_forms.forms import FormBuilder
from django.template.response import SimpleTemplateResponse


class CallToActionForm(CMSPluginBase):
    max_plugins = 1

    def add_view(self, request, form_url='', extra_context=None):
        return SimpleTemplateResponse('blog_extension/call_to_action/OverChildPlugin.html', {
                    'num_allowed': 1,
                })
        # return super(CMSPluginMaxPluginAllowed, self).add_view(request, form_url, extra_context)


class ActionForm(CallToActionForm):
    # admin_preview = False
    model = FormDefinition
    render_template = actionSettings.CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE
    require_parent = True
    parent_classes = ['CallToActionPlugin']
    # allow_children = True
    # child_classes = ['SweetChildPlugin']
    max_plugins = 1
    max_num = 1
    inlines = (FormFieldInline, )

    def get_fieldsets(self, request, obj=None):
        fieldsets = (
            (None, {'fields': ('name', )}),

            (None, {
                'description': _('You can change this template whatever you want'),
                'fields': ('form_template', )
            }),
            (None, {
                'fields': ('success_redirect', ('page_redirect', 'external_redirect'), 'redirect_delay',),
            }),
            (None, {
                'description': '<strong>Submission Settings</strong> &mdash; '
                               'Choose storage options to capture form data. You can enter '
                               'an email address to have the form submissions emailed to you or '
                               'log all the form submissions to the database.',
                'fields': ('email_to', 'email_from', 'email_subject',
                           'email_uploaded_files', 'save_data', 'spam_protection', ),
            }),
        )
        return fieldsets

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.form_template,
            # settings.DJANGOCMS_FORMS_DEFAULT_TEMPLATE,
            # 'djangocms_forms/form_template/default.html',
            actionSettings.CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        context = super(ActionForm, self).render(context, instance, placeholder)
        request = context['request']

        form = FormBuilder(
            initial={'referrer': request.path_info}, form_definition=instance,
            label_suffix='', auto_id='%s')

        redirect_delay = instance.redirect_delay or \
            getattr(settings, 'DJANGOCMS_FORMS_REDIRECT_DELAY', 1000)

        context.update({
            'form': form,
            'recaptcha_site_key': settings.DJANGOCMS_FORMS_RECAPTCHA_PUBLIC_KEY,
            'redirect_delay': redirect_delay,
            'actionId': instance.parent.action_calltoactionmodel.id,
            'actionFormId': int_to_hashid(instance.id),
            'externalFileLink': instance.parent.action_calltoactionmodel.linkUrl,
            # 'slug': 'blog'
        })

        return context


plugin_pool.register_plugin(ActionForm)




class CallToActionPlugin(CMSPluginBase):
    model = CallToActionModel
    module = _("Call To Action plugin")
    name = _("Call To Action plugin")
    render_template = actionSettings.CALL_TO_ACTION_DEFAULT_TEMPLATE
    child_classes = ['ActionForm', ]
    allow_children = True
    max_num = 1
    # inlines = (CallToActionFormInline, )
    text_enabled = True

    def icon_src(self, instance):
        return static('images/1.jpg')

    def save_model(self, request, obj, form, change):
        super(CallToActionPlugin, self).save_model(request, obj, form, change)

        # the child plugin actionform is created
        # normally it's only possible to be 1
        # obj.num_children()
        if obj.get_children_count() >= 1:
            pass
        # the child plugin actionform is not created
        else:
            # test whrther the thank page is created
            from cms.models.pagemodel import Page, TreeNode
            thankNode = TreeNode.objects.filter(
                # parent=obj.page.node,
                cms_pages__title_set__slug='thank',
                cms_pages__template='landing/ThankYou.html'
            ).distinct()
            if thankNode.exists():
                redirectPage = thankNode.all()[0].cms_pages.all()[0]
            else:
                from cms.models.titlemodels import Title
                thankNode = TreeNode(site_id=obj.page.node.site_id)
                lan = obj.language
                childPage = Page(node=childNode, template='landing/ThankYou.html', created_by=request.user, languages=lan)
                childPage.save()
                childTitle = Title(language=lan, title='Thank', slug='thank', page=childPage, path=f'{obj.page.title_set.all()[0].path}/thank')
                childTitle.save()
                childPage.publish(language=lan)
                redirectPage = childPage

            from datetime import datetime
            time = datetime.now()
            now = time.strftime("%m/%d/%Y|%H:%M:%S")
            name = f'{request.path}-{request.user.username}-{now}'
            from djangocms_forms.models import Form
            referencedForm = Form(name=name)
            referencedForm.save()
            formDefinition = FormDefinition(
                name=name,
                success_redirect=True,
                page_redirect=redirectPage,
                form_template=actionSettings.CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE,
                plugin_reference=referencedForm,
                # r
                # cmsplugin_ptr_id=childPlugin.id
            )
            formDefinition.save()



            # formDefinition = FormDefinition(
            #     name=name,
            #     success_redirect=True,
            #     page_redirect=redirectPage,
            #     form_template=actionSettings.CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE,
            #     plugin_reference=referencedForm,
            #     # cmsplugin_ptr_id=childPlugin.id
            # )
            # formDefinition.save()

            from cms.models.pluginmodel import CMSPlugin

            childPlugin = CMSPlugin.objects.get(id=formDefinition.cmsplugin_ptr_id)


            childPlugin.language = obj.language

            childPlugin.position=0
            childPlugin.plugin_type=u'ActionForm'
            childPlugin.placeholder=obj.placeholder
            childPlugin.parent=obj
            childPlugin.depth=obj.depth + 1
            childPlugin.path = obj.path + '0001'
            # childPlugin.djangocms_forms_formdefinition =
            # obj.add_child()

            # position = CMSPlugin.objects.filter(parent=obj).count()
            # childPlugin = CMSPlugin(
            #     language=obj.language,
            #     position=position,
            #     plugin_type=u'ActionForm',
            #     placeholder=obj.placeholder,
            #     parent=obj,
            #     depth=obj.depth + 1,
            # )

            # childPlugin.djangocms_forms_formdefinition = formDefinition


            childPlugin.save()

        return


    def get_render_template(self, context, instance, placeholder):


        return select_template([
            # instance.renderTemplate,
            actionSettings.CALL_TO_ACTION_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        context.update({
                'instance': instance,
            })
        return context





plugin_pool.register_plugin(CallToActionPlugin)
