from cms.toolbar_base import CMSToolbar
from cms.cms_toolbars import PlaceholderToolbar, BasicToolbar, PageToolbar
from django.utils.translation import override as force_language
from cms.toolbar_pool import toolbar_pool
from classytags.utils import flatten_context

from cms.toolbar_pool import toolbar_pool

#@toolbar_pool.register
class MyToolbarClass(PageToolbar):
    def render_with_structure(self, context, nodelist):
        # super(MyToolbarClass, self).render_with_structure(context, nodelist)
        self.populate()

        context.update(self.get_render_context())

        with force_language(self.toolbar_language):
            # needed to populate the context with sekizai content
            render_to_string('cms/toolbar/toolbar_javascript.html', flatten_context(context))

        # render everything below the tag
        rendered_contents = nodelist.render(context)

        self.post_template_populate()

        with force_language(self.toolbar_language):
            # render the toolbar content
            toolbar = render_to_string('action/toolbar/toolbar_with_structure.html', flatten_context(context))
        # return the toolbar content and the content below
        return '%s\n%s' % (toolbar, rendered_contents)



# toolbar_pool.unregister(CMSToolbar)
# toolbar_pool.register(MyToolbarClass)