from django.db import models
from cms.models import CMSPlugin
from djangocms_forms.models import FormDefinition
from filer.fields.file import FilerFileField
from cms.models.fields import PlaceholderField
from django.utils.translation import ugettext_lazy as _
from action import settings as actionSettings
# from djangocms_forms.fields import PluginReferenceField
from djangocms_forms.models import FormField, Form

# CMSPlugin FormDefinition
class CallToActionModel(CMSPlugin):
    # form = PlaceholderField('call_to_action_form',
    #                           related_name='call_to_action_form')
    # userForm = PluginReferenceField(
    #     to=None
    # )
    
    targetFile = FilerFileField(
        verbose_name=_('Shared file'),
        null=True,
        blank=True,
        on_delete=models.SET_NULL,
    )
    linkUrl = models.URLField(
        verbose_name=_('External URL'),
        blank=True,
        max_length=2040,
        help_text=_('The file link to an external URL.'),
    )
    # sharedFile = PlaceholderField('call_to_action_file',
    #                           related_name='call_to_action_file')
    renderTemplate = models.CharField(
        _('Call To Action Template'), max_length=150, blank=True,
        choices=actionSettings.CALL_TO_ACTION_TEMPLATES,
        default=actionSettings.CALL_TO_ACTION_DEFAULT_TEMPLATE,
    )


class CallToActionStatistics(models.Model):
    action = models.ForeignKey(CallToActionModel)
    token = models.CharField(max_length=80)
    email = models.CharField(max_length=500)
    count = models.IntegerField(default=0)
    url = models.CharField(max_length=500)