from django.contrib.sites.models import Site

import datetime
import logging
import urllib
import six
import hashlib
import pdfkit
import os


from unidecode import unidecode

from django.shortcuts import redirect, get_object_or_404, render
from django.views.generic import View
from django.views.static import serve
from django.core.mail import send_mail
from django.conf import settings
from django.template.loader import get_template
from django.template import Context
from django.template.base import Template
from django.contrib import auth
from django.core.validators import validate_email
from django.core.exceptions import ValidationError
from django.template.defaultfilters import slugify
from django.urls import reverse

from djangocms_forms.models import FormDefinition
from djangocms_forms.utils import hashid_to_int, int_to_hashid
from djangocms_forms.forms import FormBuilder

from Zephyrus.landing import ErrorCode
from Zephyrus.landing.models import Email

# from Zephyrus.blog_extension.models import ActionRecord, Action
from action.models import CallToActionModel, CallToActionStatistics
from filer.models.filemodels import File

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())


PDFKIT_ENV = os.path.join(settings.BASE_DIR, 'wkhtmltopdf.exe')
PDF_ROOT = 'pdf/'

# Create your views here.
class CallToActionEmailView(View):
    def post(self, request, *args, **kwargs):
        email = request.POST.get('email')
        fromUrl = request.POST.get('fromUrl')
        redirectTo = request.POST.get('redirectTo')
        # formId = request.POST.get('form_id')
        actionId = request.POST.get('callToActionId')
        return sendAndRedirect(request, email, fromUrl, redirectTo, actionId)
    def get(self, request, *args, **kwargs):
        return redirect('/')


def sendAndRedirect(request, email, fromUrl, redirectTo, actionId, formId=None, actionFormId=None):
    errorCode = ErrorCode.NORMAL

    # this is for djangocms form default
    if 'form_id' in request.POST:
        formId = hashid_to_int(request.POST.get('form_id'))
        landingForm = get_object_or_404(FormDefinition, pk=formId)
        form = FormBuilder(landingForm, data=request.POST, files=request.FILES)
        if not form.is_valid():
            return redirect(fromUrl)

        order = landingForm.fields.all()
        excludedFieldTypes = ['MathCaptcha', 'ReCaptcha']
        order = [field for field in order
                    if field.field_type not in excludedFieldTypes]

        dataDict = {}
        for field in order:
            key = slugify(unidecode(field.label).replace('-', '_'))
            value = form.cleaned_data.get(key, '(no input)')
            dataDict[key] = {'value': value, 'field': field,}

    elif formId:
        formId = hashid_to_int(formId)
        landingForm = get_object_or_404(FormDefinition, pk=formId)
        dataDict = {}
        form = True

    # this is for only social login
    else:
        landingForm = None
        form = None

    # for embed file, external link or PDF
    action = get_object_or_404(
        CallToActionModel,
        cmsplugin_ptr_id=actionId
    )
    m = hashlib.md5()
    data = f"{email}{actionId}"
    m.update(data.encode("utf-8"))
    token = m.hexdigest()
    actionRecord, created = CallToActionStatistics.objects.get_or_create(
        action=action,
        email=email,
        url=fromUrl,
        defaults={'token':token, 'count':0}
    )
    # if not created:
    #     actionRecord.count = actionRecord.count + 1
    actionRecord.save()
    domain = Site.objects.get_current().domain

    hashedActionId = int_to_hashid(int(actionId))
    link = f"{settings.META_SITE_PROTOCOL}://{domain}{reverse('showTargetFile')}?key={hashedActionId}"
    fileData = {'link': link, 'token': token}


    try:
        validate_email(email)

        # Save data to db
        try:
            if not form:
                email = Email.objects.create(
                    email=email,
                    fromUrl=fromUrl,
                )
                email.save()
            else:
                data = {}
                for key in dataDict:
                    value = dataDict[key]['value']
                    data[key] = value
                email = Email.objects.create(
                    email=email,
                    fromUrl=fromUrl,
                    data=data,
                )
                email.save()
        except Exception as e:
            errorCode = ErrorCode.SAVE_EMAIL
            logger.error('Not successfully save email: %s' % str(e))

        # Send email
        try:
            message = (
                "Customer id : %d\nCustomer email : %s\n" %
                (email.id, email.email))
            message += "Date : %s\n" % datetime.datetime.now()
            message += "From : %s\n" % fromUrl

            if not form:
                title = (
                    '[Landing %s] - customer use landing page' %
                    request.META['HTTP_HOST'])
            else:
                title = (
                    '[Landing %s] - %s' % (
                    request.META['HTTP_HOST'], landingForm.name))

            if not form:
                send_mail(
                    title,
                    message,
                    # settings.EMAIL_HOST_USER,
                    settings.DEFAULT_FROM_EMAIL,
                    settings.ZEPHYRUS_LANDING_SEND_TO,
                    fail_silently=False
                )
            else:

                message += "Other Data : \n"

                for key in dataDict:
                    value = dataDict[key]['value']
                    field = dataDict[key]['field']
                    message += "\t%s : %s\n" % (field.label, value)
                send_mail(
                    title,
                    message,
                    settings.DEFAULT_FROM_EMAIL,
                    landingForm.email_to.split(','),
                    fail_silently=False
                )

            replaceStr = {
                'email': email.email,
            }
            replaceStr.update(fileData)

            if not form:
                title = get_template('blog_extension/call_to_action/ThankEmailSubject.txt')

            else:
                title = landingForm.email_subject

            mail = get_template('blog_extension/call_to_action/FileConfirm.txt')
            message = mail.render(replaceStr)
            send_mail(
                title,
                message,
                settings.DEFAULT_FROM_EMAIL,
                [email.email,],
                fail_silently=False
            )

        except Exception as e:
            errorCode = ErrorCode.SEND_EMAIL
            logger.error('Not successfully send email: %s' % str(e))
    except ValidationError as e:
        errorCode = ErrorCode.EMAIL_FORMAT
        logger.error('Email format error: %s' % str(e))

    # Redirect
    if redirectTo:
        if six.PY3:
            url = urllib.parse.quote(redirectTo)
        else:
            url = urllib.quote(redirectTo)
    else:
        if hasattr(settings, "ZEPHYRUS_LANDING_THANK_URL"):
            url = fromUrl + settings.ZEPHYRUS_LANDING_THANK_URL
        else:
            url = fromUrl + "thank"

    url = url + "?from_url=%s&error=%d" % (fromUrl, errorCode)


    if actionFormId:
        landingForm = get_object_or_404(FormDefinition, pk=actionFormId)

    if (not form) and (not actionFormId):
        return redirect(url)

    if landingForm:

        # landingForm.success_redirect
        if landingForm.page_redirect:
            # url = landingForm.page_redirect.get_public_url() + \'
            url = landingForm.page_redirect.get_absolute_url() + \
                "?from_url=%s&error=%d" % (fromUrl, errorCode)

        # landingForm.redirect_url
        elif landingForm.external_redirect:
            url = landingForm.external_redirect + \
                "?from_url=%s&error=%d" % (fromUrl, errorCode)

        else:
            pass

    return redirect(url)

class CallToActionSocialView(View):
    def get(self, request, *args, **kwargs):
        user = request.user
        email = user.email
        fromUrl = request.GET.get('fromUrl')
        redirectTo = request.GET.get('redirectTo')
        formId = request.GET.get('formId')
        actionId = request.GET.get('callToActionId')
        actionFormId = hashid_to_int(request.GET.get('actionFormId'))
        auth.logout(request)
        return sendAndRedirect(
            request, email, fromUrl, redirectTo, actionId, formId=formId, actionFormId=actionFormId)


def showTargetFile(request):

    def returnTargetFile(request, callToActionStatistics):
        if callToActionStatistics.action.targetFile:

            path = settings.BASE_DIR + \
                settings.MEDIA_URL + \
                str(callToActionStatistics.action.targetFile.file)

            response = serve(request, path, document_root=settings.BASE_DIR)
            return response

        elif callToActionStatistics.action.linkUrl:
            return render(
                request,
                'blog_extension/call_to_action/ExternalFile.html',
                {'externalLink': callToActionStatistics.action.linkUrl}
            )

        else:
            domain = Site.objects.get_current().domain
            from aldryn_newsblog.models import Article
            slug = callToActionStatistics.url.split('/')[-2]
            article = Article.objects.filter(translations__slug=slug)
            if article:
                article = article[0]
                from cms.models import CMSPlugin
                # relatedPlugins = a.content.get_plugins()
                plugin = CMSPlugin.objects.filter(plugin_type='TextPlugin', placeholder=article.content, depth=1)
                if plugin:
                    plugin = plugin[0]
                    from djangocms_text_ckeditor.models import Text
                    text = Text.objects.get(cmsplugin_ptr_id=plugin.id)
                    html = text.body

                    def transferPicturePlugin(html):
                        index = 0
                        while index < len(html):
                            try:
                                openIndex = html[index:].index('<cms-plugin') + index
                            except ValueError:
                                break
                            else:
                                closeIndex = html[openIndex:].index('</cms-plugin>')
                                pluginHtml = html[openIndex:openIndex+closeIndex]
                                pluginIdIndex = pluginHtml.index('id') + len('id="')
                                pluginIdEnd = pluginHtml[pluginIdIndex:].index('"')
                                pluginId = pluginHtml[pluginIdIndex:pluginIdIndex+pluginIdEnd]

                                index = openIndex + closeIndex + len('</cms-plugin>')

                                plugin = CMSPlugin.objects.get(id=pluginId)

                                if plugin.plugin_type == 'PicturePlugin':
                                    from djangocms_picture.models import Picture
                                    picture = Picture.objects.get(cmsplugin_ptr_id=pluginId)

                                    src = settings.META_SITE_PROTOCOL + '://' + domain + picture.img_src
                                    # src = 'http://' + domain + picture.img_src
                                    # p.get_size()
                                    imgtag = f'</p><img src="{src}"></img>'

                                    html = html.replace(html[openIndex:index], imgtag)
                                    index = openIndex + len(imgtag)

                        return html

                    htmlString = transferPicturePlugin(html)
                    fileName = f'[{domain}]{article.slug}.pdf'
                    path = settings.MEDIA_URL[1:] + PDF_ROOT + fileName
                    try:
                        pdfkit.from_string('<head><meta charset="UTF-8"></head>' + htmlString, path)

                    # might occur as the https is at risk
                    # the file(img or any file on site) is loaded successfully
                    # with network status code 2 and http status code 0 - Connection closed
                    # Warning: SSL error ignored
                    # Done but Exit with code 1 due to network error: RemoteHostClosedError
                    except Exception:
                        pass

                # no text plugin in blog article
                else:
                    return redirect(callToActionStatistics.url)

            else:
                # make PDF directly
                # config = pdfkit.configuration(wkhtmltopdf=PDFKIT_ENV)
                import requests
                from bs4 import BeautifulSoup
                resp = requests.get(f"{settings.META_SITE_PROTOCOL}://{domain}{callToActionStatistics.url}")
                soup = BeautifulSoup(resp.text, 'html.parser')
                title = soup.find('title')
                title = title.text.replace(' ', '')
                title = title.replace('\n', '-')

                fileName = f"{title}.pdf"

                # content = soup.find('div', {'class': 'blog-grid-top'})
                # head = soup.find('head')
                # scripts = soup.findAll('script')
                # scriptText = ''.join([str(script) for script in scripts])
                # article = f'<!DOCTYPE html><html lang="zxx">{str(head)}<body>{str(content)}{scriptText}</body></html>'


                path = settings.MEDIA_URL[1:] + PDF_ROOT + fileName


                pdfkit.from_url(
                    f"{settings.META_SITE_PROTOCOL}://{domain}{callToActionStatistics.url}",
                    path,
                )
                # pdfkit.from_string(article, path)
                # configuration=config
            response = serve(request, path, document_root=settings.BASE_DIR)

            return response

    key = request.GET.get('key')
    if request.POST.get('token'):
        actionRecord = CallToActionStatistics.objects.filter(
            action_id=hashid_to_int(key),
            token=request.POST.get('token'),
        )
        if actionRecord.exists():
            actionRecord = actionRecord[0]
            actionRecord.count = actionRecord.count + 1
            actionRecord.save()
            return returnTargetFile(request, actionRecord)
        else:
            return render(
                request,
                'blog_extension/call_to_action/FileVerification.html',
                {'key': key, 'msg': 'Invalid token'}
            )



    else:
        return render(
            request,
            'blog_extension/call_to_action/FileVerification.html',
            {'key': key}
        )
