# Install cron jobs.
mkdir -p cron
echo '#!/bin/bash
source $HOME/app/bin/activate
cd /home/nuwa/app/$APP_NAME

{{ command|safe|escape }}
' > cron/{{ jobName }}
sed -i -e "s#\$HOME#$HOME#g" cron/{{ jobName }}
sed -i -e "s#\$PWD#$PWD#g" cron/{{ jobName }}
chmod +x cron/{{ jobName }}

if (( $(crontab -l | grep -c "cron_{{ jobName }}" ) == 0 )) ; then
    crontab -l > _cron
    if (( $(crontab -l | grep -c "APP_NAME=" ) == 0 )) ; then
        env >> _cron
    fi
    echo "{{ time }} $PWD/cron/{{ jobName }} >> $HOME/app/log/cron_{{ jobName }}.log" >> _cron
    crontab _cron
    rm -f _cron
fi