#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_project.py 11464 2019-04-17 06:34:50Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-04-17 15:34:50 +0900 (週三, 17 四月 2019) $
# $Revision: 11464 $

import os
import sys
import six
import datetime

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context

from Iuno.Version import IUNO_VERSION
from Iuppiter.Encoding import utf8


class Command(BaseCommand):
    help = 'Build django project with our setting and files.'

    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="Project name")
        parser.add_argument('path', type=str, nargs='?', help="Project path")

    def handle(self, *args, **options):
        path = options['path']
        name = options['name']

        if not path:
            path = os.path.join(os.getcwd(), options['name'])
        else:
            path = os.path.join(path, options['name'])

        # FIXME: 判斷 Manage.py
        if os.path.abspath(path) == os.path.abspath(
                os.path.join(os.getcwd(), options['name'])):
            os.system(
                "%s manage.py startproject %s" % (
                    sys.executable, name))
        else:
            if not os.path.exists(path):
                os.mkdir(path)

            os.system(
                "%s manage.py startproject %s \"%s\"" % (
                    sys.executable, name, path))

        import django

        if not (
            django.VERSION[0] == 1 and 
            django.VERSION[1] == 11 and 
            django.VERSION[2] == 20):
            raise CommandError("Only support django 1.11.20")

        settingPath = os.path.join(path, name, 'settings.py')
        urlPath = os.path.join(path, name, 'urls.py')

        def renderFile(template, path, fileName, linux=False):
            temp = get_template(template)
            
            context = {
                "name": name,
                "useConda": False,
                "version": IUNO_VERSION,
                "envName": os.environ.get("CONDA_DEFAULT_ENV", "%s_ENV" % name),
            }
                
            content = temp.render(context)

            if linux:
                with open(os.path.join(path, fileName), 'wb') as f:
                    if not six.PY3:
                        f.write(six.b(content.replace('\r\n', '\n')))
                    else:
                        f.write(content.replace('\r\n', '\n').encode())
            else:
                with open(os.path.join(path, fileName), 'w') as f:
                    f.write(content)

        # file -----------------------------------------------------------------
        renderFile('scaffold/Activate.bat', path, 'ActivateEnv.bat')
        renderFile('scaffold/Configure.bat', path, 'Configure.bat')
        renderFile('scaffold/Configure.sh', path, 'Configure.sh', linux=True)
        renderFile('scaffold/README.txt', path, 'README.txt')
        renderFile('scaffold/REQUIREMENTS.txt', path, 'REQUIREMENTS.txt')
        
        managementPath = os.path.join(
            os.path.dirname(settingPath), "management")
        if not os.path.exists(managementPath):
            os.mkdir(managementPath)
            
        with open(os.path.join(managementPath, "__init__.py"), 'w') as f:
            pass
            
        commandPath = os.path.join(managementPath, "commands")
        if not os.path.exists(commandPath):
            os.mkdir(commandPath)
            
        with open(os.path.join(commandPath, "__init__.py"), 'w') as f:
            pass
            
        renderFile('scaffold/Deploy.py', commandPath, 'deploy.py')

        # Settings.py ----------------------------------------------------------
        with open(settingPath, 'r') as setting:
            content = setting.read()

        # Header
        context = {
            "year": datetime.date.today().year,
        }
        temp = get_template('scaffold/HeaderTemplate.py')
        header = temp.render(context)
        content = header + content

        # debug & mode
        context = {
            "name": name.lower(),
        }
        temp = get_template('scaffold/DebugTemplate.py')
        debug = temp.render(context)
        content = content.replace('DEBUG = True', debug)

        # allow host
        temp = get_template('scaffold/AllowHostTemplate.py')
        host = temp.render(context)
        content = content.replace('ALLOWED_HOSTS = []', host)

        # install app
        context = {
            "name": name,
        }
        temp1 = get_template('scaffold/InstalledApps.py').render()
        temp2 = get_template(
            'scaffold/InstalledAppsTemplate.py').render(context)
        content = content.replace(temp1, temp2)

        # db & static
        temp = get_template('scaffold/Database.py')
        database = temp.render()
        content = content.replace(database, '')

        temp = get_template('scaffold/Static.py')
        static = temp.render()
        content = content.replace(static, '')

        temp = get_template('scaffold/TimeZone.py')
        timeZone = temp.render()
        content = content.replace(timeZone, '')
        
        # template & middleware & auth password
        temp = get_template('scaffold/Templates.py')
        templates = temp.render()
        content = content.replace(templates, '')
        
        temp = get_template('scaffold/Middleware.py')
        middleware = temp.render()
        content = content.replace(middleware, '')
        
        temp = get_template('scaffold/Auth.py')
        auth = temp.render()
        content = content.replace(auth, '')
        
        # wsgi & root urlconf
        temp = get_template('scaffold/Wsgi.py')
        wsgi = temp.render(context)
        content = content.replace(wsgi, '')
        
        temp = get_template('scaffold/Urlconf.py')
        urlconf = temp.render(context)
        content = content.replace(urlconf, '')
        
        
        # Footer
        temp = get_template('scaffold/FooterTemplate.py')
        footer = temp.render()
        content = content.strip() + '\n' + footer

        with open(settingPath, 'wb') as setting:
            if not six.PY3:
                setting.write(six.b(utf8(content.replace('\r\n', '\n'))))
            else:
                setting.write(content.replace('\r\n', '\n').encode())
        # Urls.py --------------------------------------------------------------
        with open(urlPath, 'r') as url:
            content = url.read()

        temp1 = get_template('scaffold/Urls.py').render()
        temp2 = get_template('scaffold/UrlsTemplate.py').render()
        content = content.replace(temp1, temp2)

        with open(urlPath, 'w') as url:
            url.write(content)



