#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_tree.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-16 17:31:00 +0800 (Mon, 16 Jul 2018) $
# $Revision: 11172 $

import os

from django.conf import settings
from django.core.management.base import BaseCommand

from Iuno.cloud.storage.gos import ServiceSingleton
from Iuno.cloud.storage import DEFAULTS

class Command(BaseCommand):
    def add_arguments(self, parser):
        # Positional arguments
        parser.add_argument('clientSecretPath', type=str)
        parser.add_argument('-p', type=str, help='credential path')
        parser.add_argument('-n', type=str, help='app name')

    def handle(self, *args, **options):
        credentialPath = options['p']
        appName = options['n']

        if credentialPath is None:
            credentialPath = os.path.join(
                settings.BASE_DIR, '.credentials', 'credential.json')

        credentials = ServiceSingleton.createCredentials(
            clientSecretPath=options['clientSecretPath'],
            credentialPath=credentialPath,
            scope=DEFAULTS['IUNO_CLOUD_STORAGE_GOOGLE_SCOPE'],
            appName=appName
        )
        if credentials and (not credentials.invalid):
            print('Successfully create the credentials.')
