#!/usr/bin/env python
# -*- coding: utf-8 -*-


from django.db import models
from django.utils.translation import gettext_lazy as _

TEXT = "text"
INTEGER = "integer"
BOOLEAN = "boolean"
FLOAT = "float"
RICHTEXT = "richtext"
DATE = "date"
DATETIME = "datetime"
OPTION = "option"
MULTI_OPTION = "multi_option"
ENTITY = "entity"
FILE = "file"
IMAGE = "image"
TYPE_CHOICES = (
    (TEXT, _("Text")),
    (INTEGER, _("Integer")),
    (BOOLEAN, _("True / False")),
    (FLOAT, _("Float")),
    (RICHTEXT, _("Rich Text")),
    (DATE, _("Date")),
    (DATETIME, _("Datetime")),
    (OPTION, _("Option")),
    #(MULTI_OPTION, _("Multi Option")),
    #(ENTITY, _("Entity")),
    (FILE, _("File")),
    (IMAGE, _("Image")),
)

class OptionType(models.Model):
    option = models.ForeignKey(
        'catalogue.Option',
        on_delete=models.CASCADE,
        verbose_name=_("Option")
    )
    
    type = models.CharField(
        choices=TYPE_CHOICES, default=TYPE_CHOICES[0][0],
        max_length=20, verbose_name=_("Type"))
    optionGroup = models.ForeignKey(
        'catalogue.AttributeOptionGroup',
        blank=True,
        null=True,
        on_delete=models.CASCADE,
        related_name='productAttributes',
        verbose_name=_("Option Group"),
        help_text=_(
            'Select an option group if using type "Option" or "Multi Option"'))

class ECPayTrade(models.Model):
    merchantId = models.CharField(max_length=30)
    merchantTradeNo = models.CharField(max_length=30)
    tradeNo = models.CharField(max_length=30)
    
    tradeDate = models.DateTimeField()
    paymentDate = models.DateTimeField()
    
    tradeAmt = models.IntegerField()
    payAmt = models.IntegerField()
         
    rtnCode = models.CharField(max_length=30)
    rtnMsg = models.CharField(max_length=30)
    paymentType = models.CharField(max_length=30)
    simulatePaid = models.CharField(max_length=30)
    paymentTypeChargeFee = models.CharField(max_length=30)

class AllPayTrade(models.Model):
    merchantId = models.CharField(max_length=30)
    merchantTradeNo = models.CharField(max_length=30)
    tradeNo = models.CharField(max_length=30)
    
    tradeDate = models.DateTimeField()
    paymentDate = models.DateTimeField()
    
    tradeAmt = models.IntegerField()
    payAmt = models.IntegerField()
         
    rtnCode = models.CharField(max_length=30)
    rtnMsg = models.CharField(max_length=30)
    paymentType = models.CharField(max_length=30)
    simulatePaid = models.CharField(max_length=30)
    paymentTypeChargeFee = models.CharField(max_length=30)

class SpgatewayTrade(models.Model):
    merchantId = models.CharField(max_length=30)
    merchantTradeNo = models.CharField(max_length=30)
    tradeNo = models.CharField(max_length=30)
    
    paymentDate = models.DateTimeField()
    
    paymentType = models.CharField(max_length=30)
    paymentMethod = models.CharField(max_length=30)
    tradeAmt = models.IntegerField()
         
    rtnCode = models.CharField(max_length=30)
    rtnMsg = models.CharField(max_length=30)

class CathaybkCreditTrade(models.Model):
    merchantId = models.CharField(max_length=30) # STOREID
    merchantTradeNo = models.CharField(max_length=30) # ORDERNUMBER
    tradeNo = models.CharField(max_length=30) # AUTHCODE
    
    paymentDate = models.DateTimeField() # AUTHTIME
    
    tradeAmt = models.IntegerField() # AMOUNT
         
    rtnCode = models.CharField(max_length=30) # AUTHSTATUS
    rtnMsg = models.CharField(max_length=30) # AUTHMSG
    cardNo = models.CharField(max_length=30) # CARDNO

class ECPayLogisticTrade(models.Model):
    # B2C & C2C
    merchantId = models.CharField(max_length=30) # MerchantID
    merchantTradeNo = models.CharField(max_length=30) # MerchantTradeNo
    tradeNo = models.CharField(max_length=30) # AllPayLogisticsID
    
    tradeDate = models.DateTimeField()
    updateStatusDate = models.DateTimeField() # UpdateStatusDate
    
    tradeAmt = models.IntegerField() # GoodsAmount
         
    rtnCode = models.CharField(max_length=30) # RtnCode
    rtnMsg = models.CharField(max_length=30) # RtnMsg

    receiverName = models.CharField(max_length=30) # ReceiverName
    receiverCellPhone = models.CharField(max_length=30) # ReceiverCellPhone
    receiverEmail = models.CharField(max_length=200, null=True) # ReceiverEmail

    logisticsType = models.CharField(max_length=30) # LogisticsType
    logisticsSubType = models.CharField(max_length=30) # LogisticsSubType

    # return
    rtnMerchantTradeNo = models.CharField(max_length=30, null=True)
    rtnOrderNo = models.CharField(max_length=30, null=True)

    # CVS C2C
    paymentNo = models.CharField(max_length=30, null=True) # CVSPaymentNo 
    validationNo = models.CharField(max_length=30, null=True) # CVSValidationNo 
    
