#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11520 2019-05-04 18:14:05Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-05 03:14:05 +0900 (週日, 05 五月 2019) $
# $Revision: 11520 $

import six
import urllib

from django.contrib import admin
from django.utils.html import conditional_escape 

from Iuppiter.Encoding import utf8
from Zephyrus.comment.models import Comment

@admin.register(Comment)
class CommentAdmin(admin.ModelAdmin):
    model = Comment
    
    readonly_fields = [
        'getUrl', 'user', "email", 'message', 'createDate']
        
    list_display = ['id', 'getUrl', 'user', "email", 
                    'getMessage', 'display']
    list_editable = ['display',]
    
    search_fields = ['url',]
    
    def getUrl(self, obj):
        if six.PY3:
            name = urllib.parse.unquote(str(obj.url))
        else:
            name = urllib.unquote(str(obj.url))
            
        name = utf8(name).decode('utf8')
         
        return u"<a target='_blank' href='%s'>%s</a>" % (obj.url, name)
      
    getUrl.short_description = "URL"
    getUrl.admin_order_field = 'url'
    getUrl.allow_tags = True
    
    def getMessage(self, obj):
        # 設定在 list 頁顯示的最長字數 20
        if len(obj.message) > 20:
            text = "%s..." % obj.message[:20]
        else:
            text = obj.message
        return conditional_escape(text)
      
    getMessage.short_description = "MESSAGE"
    getMessage.admin_order_field = 'message'
    getMessage.allow_tags = True
    
