#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11520 2019-05-04 18:14:05Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-05 03:14:05 +0900 (週日, 05 五月 2019) $
# $Revision: 11520 $

import six
import urllib

from django.views.generic import View, FormView
from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail
from django.utils.translation import ugettext_lazy as _
from django.utils.decorators import method_decorator
from django.contrib.auth.decorators import permission_required
from django.shortcuts import redirect, get_object_or_404
from django.contrib.auth import get_user_model

from Iuppiter.Encoding import utf8
from Zephyrus.comment.models import Comment, CommentPlugin
from Zephyrus.comment.forms import CommentForm

class CommentView(FormView): 

    form_class = CommentForm

    def form_valid(self, form):
        # create comment
        url = self.request.POST.get('url')
        message = self.request.POST.get('message')
        if self.request.user.is_anonymous():
            email = self.request.POST.get('email')
            comment = Comment(
                url=url,
                user=None,
                email=email,
                message=message,
            )
            username = email
        else:
            user = self.request.user
            comment = Comment(
                url=url,
                user=user,
                email=None,
                message=message,
            )
            username = user.username
        comment.save()
        
        # sand mail
        plugin = CommentPlugin.objects.get(id=self.request.POST.get('pluginId'))
        
        title = "[Zephyrus comment %s] somebody leave a comment." % (
            self.request.META['HTTP_HOST'])
        message = "URL: %s\nUsername: %s\nMessage:\n%s" % (
            url, username, message)
        
        if plugin.emailTo:
            emailTo = plugin.emailTo.split(',')
        else:
            User = get_user_model()
            emailTo = [
                u.email for u in User.objects.filter(is_staff=True) if u.email
            ]
        
        send_mail(
            title,
            message,
            settings.EMAIL_HOST_USER,
            emailTo,
            fail_silently=False
        )
            
        return redirect(url)
        
    def form_invalid(self, form):
        url = self.request.POST.get('url')
        
        if form.errors:
            for e in form.errors:
                messages.error(self.request, form.errors[e])
                
        return redirect(url)
        
class CommentHideView(View): 

    @method_decorator(
        permission_required('comment.delete_comment', raise_exception=True))
    def dispatch(self, request, *args, **kwargs):
        return super(CommentHideView, self).dispatch(request, *args, **kwargs)
        
    def post(self, request, *args, **kwargs):
        pk = kwargs["pk"]
        
        comment = get_object_or_404(Comment, id=pk)
        
        if request.user.is_staff:
            comment.display = False
            comment.save()
        return redirect(comment.url)
        