#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11884 2020-01-20 08:51:15Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-01-20 16:51:15 +0800 (Mon, 20 Jan 2020) $
# $Revision: 11884 $


from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class Settings(object):

    MAP_DEFAULT_TEMPLATE = \
        "map/Default.html"

    MAP_TEMPLATES = [
        (MAP_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'MAP_TEMPLATES'):
        for ele in _settings.MAP_TEMPLATES:
            if not ele[0] == "map/Default.html":
                MAP_TEMPLATES.append(ele)

settings = Settings()
