# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-03-24 12:28
from __future__ import unicode_literals

import hashlib

from django.db import migrations, models, transaction

def makeChecksum(apps, schema_editor):
    myModel = apps.get_model('statistics', 'Url')
    with transaction.atomic():
        for row in myModel.objects.all():
            row.checksum = hashlib.md5(row.url.encode("utf-8")).hexdigest()
            row.save()
                
class Migration(migrations.Migration):

    dependencies = [
        ('statistics', '0003_auto_20190611_2345'),
    ]

    operations = [
        migrations.AddField(
            model_name='url',
            name='checksum',
            field=models.CharField(max_length=64, unique=True, null=True),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='url',
            name='url',
            field=models.URLField(max_length=2048),
        ),
        migrations.RunPython(makeChecksum),
        
    ]
