#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_toolbars.py 12270 2020-05-26 04:48:53Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-05-26 12:48:53 +0800 (Tue, 26 May 2020) $
# $Revision: 12270 $

from django.utils.http import urlquote  as django_urlquote
from django.utils.translation import override as force_language
from django.utils.translation import ugettext_lazy as _

from cms.toolbar_pool import toolbar_pool
from cms.utils.conf import get_cms_setting
from cms import cms_toolbars

class PageToolbar2(cms_toolbars.PageToolbar):
    def add_structure_mode_item(self, 
        extra_classes=('cms-toolbar-item-cms-mode-switcher',)):
        self.toolbar.request_path = django_urlquote(self.toolbar.request_path)
        return super(PageToolbar2, self).add_structure_mode_item(
                extra_classes=extra_classes)
                    
toolbar_pool.toolbars['cms.cms_toolbars.PageToolbar'] = PageToolbar2


