#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 11593 2019-05-29 06:23:49Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-29 14:23:49 +0800 (Wed, 29 May 2019) $
# $Revision: 11593 $

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.template.loader import select_template

from Zephyrus.comment import settings as _settings
from Zephyrus.comment.models import (
    CommentPlugin, Comment, RecentResponsePlugin, CommentConfig)
from Zephyrus.comment.forms import CommentForm

class CMSCommentPlugin(CMSPluginBase):
    model = CommentPlugin
    module = _("Comment")
    name = _("Comment")
    render_template =_settings.ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            _settings.ZEPHYRUS_COMMENT_TEMPLATES,
        ])

    def render(self, context, instance, placeholder):
        request = context['request']
        url = request.build_absolute_uri(request.path)

        comments = Comment.objects.filter(url=url, display=True, facebook=False)

        obj, created = CommentConfig.objects.get_or_create(
            url=url,
            defaults={'useFbComment': False},
        )
        obj.useFbComment = instance.useFbComment
        obj.save()
        
        context.update({
            'plugin': instance,
            'url': url,
            'comments': comments,
            'form': CommentForm(),
        })
        return context

class CMSRecentResponsePlugin(CMSPluginBase):
    model = RecentResponsePlugin
    module = _("Comment")
    name = _("Recent Response")
    render_template = _settings.ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            _settings.ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        comments = Comment.objects.order_by('-createDate')
        
        if comments.count() >= instance.limit:
            comments = comments[:instance.limit]
        else:
            comments = comments
            
        context.update({
            'comments': comments,
        })
        return context

plugin_pool.register_plugin(CMSCommentPlugin)
plugin_pool.register_plugin(CMSRecentResponsePlugin)