#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11178 2018-07-22 12:34:44Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-22 21:34:44 +0900 (週日, 22 七月 2018) $
# $Revision: 11178 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

from cms.models import CMSPlugin

TYPE_CHOICE = (
    ('a',  _("Icon 1")),
    ('b',  _("Icon 2")),
    ('c',  _("Icon 3")),
    ('d',  _("Icon 4")),
    ('e',  _("Icon 5")),
    ('f',  _("Icon 6")),
    ('g',  _("Icon 7")),
    ('h',  _("Icon 8")),
)

class Transmission(CMSPlugin):
    type = models.CharField(
        _("Type"),
        max_length=1,
        choices=TYPE_CHOICE,
        default='a',
    )

    url = models.URLField(
        null=True, 
        max_length=400,
        blank=True, 
        default=None,
        help_text=_('If not provided, it will use current url by default.')
    )

class ShareLike(CMSPlugin):
    url = models.URLField(
        null=True, 
        max_length=400,
        blank=True, 
        default=None,
        help_text=_('If not provided, it will use current url by default.')
    )

    lineId = models.CharField(
        _("LINE ID"),
        max_length=50,
        default=None,
        null=True,
        blank=True,
        help_text=_('If provided, it will display friend button.')
    )

    share = models.BooleanField(_("Share"), default=True)

class BeFriend(CMSPlugin):
    lineId = models.CharField(
        _("LINE ID"),
        max_length=50,
    )

    count = models.BooleanField(_("Show count"), default=False)
    home = models.BooleanField(_("Show home"), default=False)
