#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: StatisticsTags.py 11641 2019-06-19 07:33:01Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-19 15:33:01 +0800 (Wed, 19 Jun 2019) $
# $Revision: 11641 $

import requests
import json

from django import template
from django.conf import settings
from django.utils.http import urlquote

from Zephyrus.facebook import settings as FBSettings
from Zephyrus.facebook import getAPIData
from Zephyrus.statistics.models import URL

register = template.Library()

def getURL(context, url=None):
    request = context['request']
    if url:
        if not url.startswith('http'): 
            url = request.build_absolute_uri('/')[:-1].strip("/") + url
    else:
        url = request.build_absolute_uri(request.path)

    return url

@register.simple_tag(takes_context=True)
def viewCount(context, url=None):
    request = context['request']
    if url:
        if not url.startswith('http'): 
            url = request.build_absolute_uri('/')[:-1].strip("/") + url
    else:
        url = request.build_absolute_uri(request.path)
        
    obj, created = URL.objects.get_or_create(
        url=url,
    )
    
    return obj.viewCount

@register.simple_tag(takes_context=True)
def commentCount(context, url=None):
    url = getURL(context, url=url)

    urlObj, created = URL.objects.get_or_create(
        url=url,
    )
    
    return urlObj.commentCount

@register.simple_tag(takes_context=True)
def likeCount(context, url=None):
    url = getURL(context, url=url)

    urlObj, created = URL.objects.get_or_create(
        url=url,
    )
    
    count = getAPIData(url, "share_count")
    urlObj.likeCount = count
    urlObj.save()
    
    return urlObj.likeCount

    