#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 11720 2019-09-23 06:12:17Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-09-23 15:12:17 +0900 (週一, 23 九月 2019) $
# $Revision: 11720 $

import re

from django.core.exceptions import PermissionDenied
from django.utils.deprecation import MiddlewareMixin

from Iuno.ban.models import Ban

class BanSpamMiddleware(MiddlewareMixin):

    def process_request(self, request):
    
        if request.POST:
        
            # for models
            urls = []
            for ban in Ban.objects.all():
                pattern = re.compile(ban.urlPattern)
                keywords = {}
                urls.append((pattern, ban))
                
            
            # match url
            for pattern, ban in urls:
                if pattern.search(request.path):
                    # match post data
                    keywords = ban.keywords.filter(enable=True)
                    for column, value in request.POST.items():
                        for keyword in keywords:
                            if column == keyword.column:
                                if keyword.useRegularExpression:
                                    v = re.compile(keyword.value)
                                    if v.search(value):
                                        raise PermissionDenied()
                                else:
                                    v = keyword.value                                    
                                    if v in value:
                                        raise PermissionDenied()
                                        
        return None
 
    def process_response(self, request, response):
        return response