#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11700 2019-09-05 08:49:19Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-09-05 17:49:19 +0900 (週四, 05 九月 2019) $
# $Revision: 11700 $
#
# Contributors:
#  Bear
#  Yachu

import random
import json
import requests

from django.urls import reverse
from django.conf import settings
from django.http import JsonResponse, Http404
from django.contrib.sites.shortcuts import get_current_site
from django.views.decorators.csrf import csrf_exempt
from django.template import Context, Template

from Iuno.cloud.sms import SMS

@csrf_exempt  
def sendSMSCaptcha(request):
    if request.POST:
        phone = request.POST.get("phone")
        temp = request.POST.get("template")
        if not phone or not temp:
            raise Http404()
        
        prefix = "".join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ') for i in range(3)])
        code = "".join([random.choice('0123456789') for i in range(6)])
        
        message = Template(temp)
        message = message.render(Context({
            "prefix": prefix,
            "code": code,
        }))
        
        payload = {
            "phone": phone,
            "message": message,
            "token": settings.IUNO_CLOUD_SMS_CLIENT_TOKEN,
        }
        
        response = requests.post(settings.IUNO_CLOUD_SMS_CLIENT_URL, payload) 
        data = json.loads(response.text)
        
        if data.get("stats"):
            data.update({
                "prefix": prefix,
                "code": code,
            })
        data.update({
            "prefix": prefix,
            "code": code,
        })
        
        return JsonResponse(data)
    raise Http404()

@csrf_exempt    
def callAPISMS(request):
    if request.POST:
        from Iuno.cloud.sms.models import Token
        
        phone = request.POST.get("phone")
        message = request.POST.get("message")
        token = request.POST.get("token")
        token = Token.objects.filter(token=token).first()
        
        if phone and message and token:
            sms = SMS([phone], message, username=token.username, password=token.password)
            result = sms.sendMessage()
            result = sms.getSendingDetails()[0]
        else:
            result = {
                "stats": False,
                "error_msg": "permission denied",
            }
            
        return JsonResponse(result)
    raise Http404()