#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 12312 2020-06-04 08:12:22Z Casey $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-06-04 16:12:22 +0800 (Thu, 04 Jun 2020) $
# $Revision: 12312 $
import datetime

from django.urls import reverse
from django.urls.base import reverse_lazy
from django.shortcuts import render, redirect
from django.utils.deprecation import MiddlewareMixin
from django.http import HttpResponseRedirect, HttpResponse
from django.contrib import admin, messages
from django.conf import settings
from django.conf.urls.static import static

from Iuno import DEVELOPMENT, STAGE, PRODUCTION
import Iuno
SERVER_MODE = Iuno.detectServerMode(locals())

from Iuno.maintenance.models import MaintenanceHistory, MaintenanceSetting



class MaintenanceMiddleware(MiddlewareMixin):
    def initialSetting(self):
        settings = MaintenanceSetting.objects.all()
        # 最一開始（沒有資料時）給設定值
        if not settings:
            MaintenanceSetting.objects.create(
                status=False,
                fixedUI=True,
                openFrontEnd=False
            )

    def getAdminReverse(self):
        adminUrl = admin.site.urls[0]
        adminIndex = reverse('admin:index')

        adminUrlList = []
        for each in adminUrl:
            adminUrlList.append(adminIndex+str(each.pattern))

        return adminUrlList

    def getHtmlWithLanguage(self,request):
        language = request.LANGUAGE_CODE
        staticUrl = settings.STATIC_URL

        if language == 'zh-hant':
            url = staticUrl + 'html/zh/Maintenance.html'
        else:
            url = staticUrl + 'html/en/Maintenance.html'

        return url

    def process_view(self, request, view_func, view_args, view_kwargs):
        self.initialSetting()

        # 拿設定值
        status = MaintenanceSetting.objects.all()[0].status
        fixedUI = MaintenanceSetting.objects.all()[0].fixedUI
        openFrontEnd = MaintenanceSetting.objects.all()[0].openFrontEnd

#         adminUrlList = self.getAdminReverse()
        requestUrl = f'/{request.path.split("/")[1]}/'
        adminIndex = reverse('admin:index')


        if status:# 如果維護模式設定的 status 為 Yes，代表開啟，要被導頁

            messages.add_message(
                request, messages.INFO, '維護模式開啟，請勿隨意修改'
            )

            # 當使用者不是 superuser 時
            if not request.user.is_superuser or \
                (request.user.is_superuser and not openFrontEnd):
                # /admin 不會被導頁
                if requestUrl == adminIndex:
                    return None
                # template 為 fixed UI
                if fixedUI:
#                     if SERVER_MODE == DEVELOPMENT:
                    html = self.getHtmlWithLanguage(request)
                    return HttpResponseRedirect(html)

                # template 為 extend 原樣板
                else:
                    return render(request, 'MaintenanceExtend.html')
            else:# 當使用者是 superuser 時,和開放前台
                return None
        else:
            return None






