#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LocalTest.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import os
import unittest

INI = os.path.abspath(os.path.join(os.path.dirname(os.path.abspath(__file__)),
                                   'LocalTest.ini'))

from Iuppiter import test as TestUtil

TestUtil.chdirToRootDir()

from Iuppiter.Function import enhance

import Iuno.cloud
from Iuno.cloud.logging.backend import Local

class LocalTest(unittest.TestCase):

    def setUp(self):
        super(LocalTest, self).setUp()

        def _checkHttp(f, self, *args, **kws):
            return True

        # Mock status check.
        Local.Backend._checkHttp = enhance(Local.Backend._checkHttp,
                                           _checkHttp)

    def testBySettings(self):
        """
        Test Local backend configuration by settings.
        """
        settings = {
            'INSTALLED_APPS': (),
        }
        
        import hashlib
        
        public = hashlib.md5(b'testBySettings-1').hexdigest()
        secret = hashlib.md5(b'testBySettings-1').hexdigest()

        dsn = 'threaded+https://%s:%s@localhost/1' % (public, secret)
        
        Iuno.cloud.attachSettings(settings, services=('logging',),
                                  serviceSettings={
                                      'logging': {
                                          'backendClasses': (Local.Backend,),
                                          'dsn': dsn,
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['RAVEN_CONFIG']['dsn'], dsn)

        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_LOGGING_BACKEND_HOST': 'sentry.nuwainfo.com',
            'HOST_OS': 'windows',
        }     

        Iuno.cloud.attachSettings(settings, services=('logging',),
                                  serviceSettings={
                                      'logging': {
                                          'project': 'test',
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')


        self.assertTrue('@sentry.nuwainfo.com' in 
                        settings['RAVEN_CONFIG']['dsn'])
        self.assertTrue('RAVEN_CONFIG' in settings)

    def testByConfig(self):
        """
        Test Local backend configuration by configuration file.
        """
        settings = {
            'INSTALLED_APPS': (), 
            'IUNO_CLOUD_LOGGING_LOCAL_CONFIG': INI,
        }        
        
        Iuno.cloud.attachSettings(settings, services=('logging',),
                                  serviceSettings={
                                      'logging': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['RAVEN_CONFIG']['dsn'], 
            ('threaded+https://419b30ac13704aabb4efaacfa99c5736:'
             '301644578dc44afaaef54940223686f8@localhost/1'))

        self.assertTrue('RAVEN_CONFIG' in settings)

if __name__ == "__main__":
    unittest.main()
