# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-03-25 13:56
from __future__ import unicode_literals

import datetime

from django.utils import timezone
from django.db import migrations, models

def getExpectedExpiredTime(config, record):
    if not record.expiredTime:
        if config.expiryDays >= 0:
            if not record.expiredTimeSetting:
                # 動態產生
                return record.createdTime + datetime.timedelta(days=config.expiryDays)
            else:
                # 固定時間
                return record.expiredTimeSetting
        else:
            # 沒有設定
            return None
    else:
        # 已經過期
        return record.expiredTime

def setExpiredTime(apps, schemaEditor):
    try:
        BonusRecord = apps.get_model('shop', 'BonusRecord')
        Bonus = apps.get_model('shop', 'Bonus')
        BonusSettings = apps.get_model('shop', 'BonusSettings')
    except:
        # do nothing
        return
        
    config, created = BonusSettings.objects.get_or_create()
    
    now = timezone.localtime(timezone.now())
    
    for b in Bonus.objects.all():      
        bonusRecords = BonusRecord.objects.filter(user=b.user).order_by('createdTime')
        
        for record in bonusRecords:
            expectedExpiredTime = getExpectedExpiredTime(config, record)
            if expectedExpiredTime:
                if expectedExpiredTime <= now and not record.expiredTime:
                    # 過期，expiredTime 沒值
                    canUsingBonus = record.receive + record.adjust - record.usedBonus - record.expiredBonus
                    if record.expiredBonus == 0 and canUsingBonus > 0:
                        # 未記錄過過期
                        record.expiredBonus = canUsingBonus
                        
                    # 已記錄過過期，紀錄時間
                    record.expiredTime = expectedExpiredTime
                    record.save()

class Migration(migrations.Migration):

    dependencies = [
        ('shop', '0019_auto_20200319_1534'),
    ]

    operations = [
        migrations.AlterModelManagers(
            name='bonusrecord',
            managers=[
            ],
        ),
        migrations.AddField(
            model_name='bonusrecord',
            name='expiredTime',
            field=models.DateTimeField(null=True, verbose_name='Expired Time'),
        ),
        migrations.AddField(
            model_name='bonusrecord',
            name='expiredTimeSetting',
            field=models.DateTimeField(null=True, verbose_name='Expired Time Setting'),
        ),
        migrations.AddField(
            model_name='bonusrecord',
            name='note',
            field=models.TextField(null=True, verbose_name='Note'),
        ),
        migrations.RunPython(setExpiredTime),
    ]
