#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 9166 2013-05-16 06:52:28Z Eric $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2013-05-16 06:52:28 +0000 (週四, 16 五月 2013) $
# $Revision: 9166 $

from django.conf.urls import url, include, patterns
# Required import for 404 handle.
from django.conf.urls import handler404
# Required import for 500 handle.
from django.conf.urls import handler500
from django.contrib import admin

admin.autodiscover()

import views

urlpatterns = patterns('',
    # Homepage.
    (r'^$', views.getIndex),

    # Django admin.
    #(r'^admin/doc/', include('django.contrib.admindocs.urls')),
    (r'^admin/', include('Theophrastus.document.urls')),
    (r'^admin/', include(admin.site.urls)),

    # Newsletter.
    url(r'^newsletters/', include('Theophrastus.urls')),

    # Tinymic editor.
    (r'^tinymce/', include('tinymce.urls')),
)

import settings
from Iuno import Patch
Patch.attachURLs(settings, urlpatterns)
