#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: forms.py 10851 2018-03-18 00:28:06Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2013-01-30 12:13:45 +0800$
# $Revision: 10851 $

from django import forms
from django.utils.translation import gettext as _

from tinymce.widgets import TinyMCE
from Theophrastus.newsletter_extension.models import Header, Footer

# Temporarily use CustomTinyMCEWidget from editor app to avoid bug in header
# editor page. 
# See more at https://code.nuwainfo.com/trac/mercurius/ticket/3057#comment:51
from Theophrastus.editor.TinyMCEWidget import CustomTinyMCEWidget

class HeaderTinyMCEForm(forms.ModelForm):
    """
    Form for header.
    """
    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 80, 'rows': 80}),
        label=_("Content"),
        required=False)

    class Meta:
        model = Header
        fields = '__all__'

class FooterTinyMCEForm(forms.ModelForm):
    """
    Form for footer.
    """
    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 80, 'rows': 80}),
        label=_("Content"),
        required=False)

    class Meta:
        model = Footer
        fields = '__all__'
