#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 12432 2020-07-29 12:27:09Z Lavender $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-07-29 21:27:09 +0900 (週三, 29 七月 2020) $
# $Revision: 12432 $ 

import json

from importlib import import_module

from django.conf import settings
from django.utils.deprecation import MiddlewareMixin
from oscar.core.loading import get_model

from Iuno.shop.models import TradeSession

from Iuno.shop.views import SPGATEWAY, ALLPAY, ECPAY, ECPAY_LOGISTIC, ECPAY_MAP

PAYMENTS = [SPGATEWAY, ALLPAY, ECPAY, ECPAY_LOGISTIC, ECPAY_MAP,]

Basket = get_model('basket', 'Basket')

class PaymentSessionMiddleware(MiddlewareMixin):

    def __init__(self, get_response=None):
        self.get_response = get_response
        engine = import_module(settings.SESSION_ENGINE)
        self.SessionStore = engine.SessionStore

    def process_request(self, request):
        for payment in ["%s" % payment for payment in PAYMENTS]:
            if request.POST and payment in request.path:
                basket = None
                
                # merchantTradeNo
                if ("/%s/" % ECPAY in request.path or 
                    "/%s/" % ALLPAY in request.path or 
                    "/%s/" % ECPAY_LOGISTIC in request.path):
                    merchantTradeNo = request.POST.get('MerchantTradeNo')
                elif "/%s/" % SPGATEWAY in request.path:
                    data = json.loads(request.POST.get('JSONData', '{}'))
                    result = json.loads(data.get('Result', '{}'))
                    merchantTradeNo = result.get("MerchantOrderNo")
                elif "/%s/" % ECPAY_MAP in request.path:
                    extra = request.POST.get("ExtraData")
                    splitData = extra.split(",")
                    if len(splitData) == 3:
                        basket = splitData[2][len("basket="):]
                        name = splitData[1][len("name="):]
                        phone = splitData[0][len("phone="):]
                        merchantTradeNo = 'BASKETID%s' % basket
                    else:
                        merchantTradeNo = None
                else:
                    merchantTradeNo = None
                 
                # basket
                if merchantTradeNo:
                    index = merchantTradeNo.find('BASKETID')
                    if index >= 0: # 表示有 BASKETID
                        basketId = int(merchantTradeNo[index + 8:])
                        basket = Basket.objects.get(id=basketId)
                        
                        tradeSession = TradeSession.objects.get(basket=basket)       
                        request.session = self.SessionStore(tradeSession.sessionKey)
                        break
                