#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
# $Revision: 9579 $

from django import forms
from django.contrib import admin
from django.utils.translation import gettext as _

from emencia.django.newsletter.models import Newsletter
from emencia.django.newsletter.admin import NewsletterAdmin

from TinyMCEWidget import CustomTinyMCEWidget

class NewsletterTinyMCEForm(forms.ModelForm):

    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 150, 'rows': 80}),
        label=_("Content"))

    def clean_header_reply(self):
        """
        Validate reply value.
        """
        reply = self.cleaned_data["header_reply"]
        try:
            reply.encode()
        except UnicodeEncodeError:
            raise forms.ValidationError(
                _("Incorrect value for reply, it can only include English "
                "word, number and symbol."))
        return reply

    class Meta:
        model = Newsletter
        fields = '__all__'

class NewsletterTinyMCEAdmin(NewsletterAdmin):

    list_display = ('title', 'mailing_list', 'server', 'status',
                    'formatedSendingDate', 'formatedCreationDate',
                    'formatedModificationDate',
                    'historic_link', 'statistics_link')

    def formatedSendingDate(self, obj):
        return obj.sending_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedSendingDate.short_description = _('sending date')

    def formatedCreationDate(self, obj):
        return obj.creation_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedCreationDate.short_description = _('creation date')

    def formatedModificationDate(self, obj):
        return obj.modification_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedModificationDate.short_description = _('modification date')

    class Media:
        try:
            js = [
                'js/Newsletter.js',
            ]
        except AttributeError:
            pass

    form = NewsletterTinyMCEForm

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterTinyMCEAdmin)
