#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9754 2017-02-18 05:34:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-02-18 13:34:31 +0800 (?g??, 18 ?G?? 2017) $
# $Revision: 9754 $

import requests
import json

from django import template
from django.conf import settings
from django.utils.http import urlquote

from Zephyrus.facebook import settings as FBSettings
from Zephyrus.facebook import getAPIData
from Zephyrus.statistics.models import URL

register = template.Library()

def getURL(context, url=None):
    request = context['request']
    if url:
        if not url.startswith('http'): 
            url = request.build_absolute_uri('/')[:-1].strip("/") + url
    else:
        url = request.build_absolute_uri(request.path)

    return url

@register.simple_tag(takes_context=True)
def viewCount(context, url=None):
    request = context['request']
    if url:
        if not url.startswith('http'): 
            url = request.build_absolute_uri('/')[:-1].strip("/") + url
    else:
        url = request.build_absolute_uri(request.path)
        
    obj, created = URL.objects.get_or_create(
        url=url,
    )
    
    return obj.viewCount

@register.simple_tag(takes_context=True)
def commentCount(context, url=None):
    url = getURL(context, url=url)

    urlObj, created = URL.objects.get_or_create(
        url=url,
    )
    
    return urlObj.commentCount

@register.simple_tag(takes_context=True)
def likeCount(context, url=None):
    url = getURL(context, url=url)

    urlObj, created = URL.objects.get_or_create(
        url=url,
    )
    
    count = getAPIData(url, "share_count")
    urlObj.likeCount = count
    urlObj.save()
    
    return urlObj.likeCount

    