#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

from django.db.models.signals import post_save
from django.dispatch import receiver

from Zephyrus.facebook.models import APIData
from Zephyrus.statistics.models import URL
from Zephyrus.comment.models import CommentConfig, Comment

@receiver(post_save, sender=APIData)
def updateURL(sender, instance, **kwargs):
    obj, created = URL.objects.get_or_create(
        url=instance.url,
    )

    # 處理 fb 的 likeCount
    obj.likeCount = instance.likeCount

    # 處理 fb 的 commentCount
    obj.commentCount = instance.commentCount
    
    obj.save()

@receiver(post_save, sender=Comment)
def updateCommentCount(sender, instance, **kwargs):
    obj, created = URL.objects.get_or_create(
        url=instance.url,
    )
    config, created = CommentConfig.objects.get_or_create(
        url=instance.url,
        defaults={'useFbComment': False},
    )

    # 處理我們自己的commentCount
    if not config.useFbComment:
        count = Comment.objects.filter(url=instance.url, display=True).count()
        obj.commentCount = count
        obj.save()

