#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: pluginize.py 10626 2017-12-10 09:05:41Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-12-10 17:05:41 +0800 (週日, 10 十二月 2017) $
# $Revision: 10626 $

import os
import json
import logging
import shutil
import hashlib
import traceback

from django.core.management.base import BaseCommand, CommandError
from django.core.management import call_command
from django.test.client import RequestFactory
from django.db import transaction
from django.template.loader import get_template
from django.template import Context
from django.conf import settings
from django.template import Template

from djangocms_text_ckeditor.cms_plugins import TextPlugin
from cms.templatetags.cms_tags import *
from filer.models.filemodels import File
from cms.models.pagemodel import Page
from lxml.html import fromstring

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, FIXTURES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "Pluginize.log")

jsPath = os.path.join(STATIC_DIR_PATH, 'js', 'FixTemplate.js')

complexity = 0

tagList = []

class Attr(object):
    def __init__(self, name, value):
        self.name = name
        self.value = value 

class Tag(object):
    def __init__(self, tagName, placeholderName, md5, attrList):
        self.tag = tagName
        self.name = placeholderName
        self.md5 = md5
        self.attrList = attrList

    def __eq__(self, other):
        if self.name == other.name and self.tag == other.tag:
            return True
        return False

class Placeholder2(Placeholder):

    lang = 'zh-hant'

    def render_tag(self, context, name, extra_bits, nodelist=None):
        super(Placeholder2, self).render_tag(context, name,
                                                       extra_bits, nodelist)
        content = nodelist.render(context)
        
        self.writeContent(name, content)
        return content

    def writeContent(self, name, content):
        # get placeholderId by name in cms_placeholder
        # if placeholderId has no plugin, add textPlugin to cms_plugin
        # query plugin id, then write content to django_text_ckeditor_text
        from django.db import models
        from cms.models.placeholdermodel import Placeholder
        from cms.models.pluginmodel import CMSPlugin
        from djangocms_text_ckeditor.models import Text
        from cmsplugin_filer_image.models import FilerImage

        placeholders = Placeholder.objects.filter(slot=name)

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

            if 'complexity' in data:
                data['complexity'] = \
                    data['complexity'] + (len(placeholders) / 2)
            else:
                data['complexity'] = len(placeholders) / 2

            with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                line = json.dumps(data)
                f.write(line)
        
        for placeholder in placeholders:
            # logger.info("id: %s, name: %s" % (placeholder.id, placeholder.slot))
            hasTextPlugin = Text.objects.filter(
                                    placeholder=placeholder, position=0
                            ).exists()
            hasImgPlugin = FilerImage.objects.filter(
                                        placeholder=placeholder).exists()

            if not hasTextPlugin and not hasImgPlugin:
                string = content.lower().strip()
                
                isOutSideTag = False
                if string.startswith('<') and string.endswith('>'):
                    isOutSideTag = True

                isImgTag = False
                if '>' in string:
                    index = string.index('>')
                    if index == len(string) - 1:
                        isImgTag = True
                        
                isImgA = False
                if isOutSideTag and string.startswith('<a'):
                    root = fromstring(content)
                    children = root.getchildren()
                    if len(children) == 1:
                       if children[0].tag == 'img':
                           isImgA = True
                     
                if (string.startswith('<img') and isImgTag) or isImgA:
                    
                    root = fromstring(content)
                    
                    if isImgA:
                        img = root.getchildren()[0]
                        # add a attrs
                        attrList = []
                        attrs = root.items()
                        for k, v in attrs:
                            if k == 'href':
                                continue
                            attrList.append(Attr(k, v))
                        
                        
                        tagList.append(
                            Tag('a', placeholder.slot, 
                            hashlib.md5(
                                placeholder.slot).hexdigest(), attrList))
                    else:
                        img = root
                    
                    
                    # find img src
                    url = img.get('src')
                    if url is None:
                        continue

                    if url.startswith("{% static \"") and url.endswith("\" %}"):
                        url = "/static/" + url[12:-4]

                    # add img attrs
                    attrList = []
                    attrs = img.items()
                    for k, v in attrs:
                        if k == 'src':
                            continue
                        attrList.append(Attr(k, v))
                    
                    
                    tagList.append(
                        Tag('img', placeholder.slot, 
                        hashlib.md5(placeholder.slot).hexdigest(), attrList))
                    
                    
                    if root.tag == 'a':
                        link = root.get('href')
                        FilerImage.objects.create(
                            placeholder=placeholder,
                            language=Placeholder2.lang,
                            caption_text='', image_url=url,
                            plugin_type='FilerImagePlugin',
                            free_link=link)

                    else:
                        FilerImage.objects.create(
                            placeholder=placeholder,
                            language=Placeholder2.lang,
                            caption_text='', image_url=url,
                            plugin_type='FilerImagePlugin',)
                    
                else:
                    textPlugin = Text.objects.create(
                        placeholder=placeholder,
                        language=Placeholder2.lang,
                        body=content, plugin_type='TextPlugin')

class Command(BaseCommand):
    
    help = 'Add TextPlugin to default placeholders which are without plugin.'
    args = '[language]'
    
    # Validation is called explicitly each time the server is reloaded.
    requires_model_validation = False
    
    def handle(self, language='', *args, **options):
        try:
            from django import template
            from django.core.urlresolvers import reverse
            from django.contrib.auth.models import AnonymousUser
            
            from sekizai.context import SekizaiContext
            
            from cms.templatetags.cms_tags import register
            
            if language:
                Placeholder2.lang = language
            else:
                if hasattr(settings, 'LANGUAGE_CODE'):
                    Placeholder2.lang = settings.LANGUAGE_CODE
            
            register.tags['placeholder'] = Placeholder2
            #register.tag(Placeholder2)
            
            path = TEMPLATES_DIR_PATH
            logger.info('Processing...')

            if not os.path.exists(os.path.join(STATIC_DIR_PATH, 'js')):
                os.mkdir(os.path.join(STATIC_DIR_PATH, 'js'))
                
            if not os.path.exists(FIXTURES_DIR_PATH):
                os.mkdir(FIXTURES_DIR_PATH)
                with open(
                    os.path.join(FIXTURES_DIR_PATH, '__init__.py'), 'w') as f:
                    pass
                
            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                    data = json.load(jsonfile)

                data['pages'] = len(os.listdir(path))

                with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                    line = json.dumps(data)
                    f.write(line)

            """
            with open(jsPath, 'w') as f:
                f.write("$j( document ).ready(function() {\n")
            """
            @transaction.atomic
            def process():
                for file in os.listdir(path):
                    file = os.path.join(path, file)
                    
                    result = os.path.splitext(file)[-1]
                    if not result == ".html":
                        continue
                        
                    logger.info(file)
                    f = open(file)
                    t = template.Template(f.read())
                    c = SekizaiContext()
                    factory = RequestFactory()
                    c['request'] = factory.get('/' + Placeholder2.lang + '/')
                    c['request'].user = AnonymousUser()
                    c['request'].current_page = Page.objects.get(pk=1)
                    t.render(c)
                    f.close()

            process()
            """
            divClass = 'div' + hashlib.md5(' __tmp__img__div').hexdigest()
            with open(jsPath, 'a+') as f:
                f.write("$j('.%s').remove();\n" % divClass)
                f.write("});")
            """
            # Unique List obj
            newTagList = []
            for tag in tagList:
                notAdd = False
                for tag2 in newTagList:
                    if tag2 == tag:
                        notAdd = True
                if not notAdd:
                    newTagList.append(tag)
            temp = get_template('boilerplate/js/FixTemplate.js')
            replaceStr = Context({
                'tagList': newTagList, 
            })
            
            content = temp.render(replaceStr)
            with open(jsPath, 'w') as f:
                f.write(content)

            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                    data = json.load(jsonfile)
            
                if 'complexity' in data:
                    logger.info('Complexity : %d' % data['complexity'])
                else:
                    logger.error('%s Complexity = 0' % data['slug'])
                    raise CommandError('%s Complexity = 0' % data['slug'])
                if 'upc' in data:
                    logger.info('UPC : %s' % data['upc'])

                for file in os.listdir(path):
                    file = os.path.join(path, file)
                    with open(file) as f:
                        content = f.read()
                    content = content.replace(
                        "complexity=CMS_PLUGINIZE_REPLACE", 
                        "complexity=%d" % data['complexity'])
                    with open(file, 'w') as f:
                        f.write(content)
            
            logger.info('DONE!')
        except Exception as e:
            logger.error("pluginize error:%s" % e)
            with open('./AllError.log', 'w+') as log:
                log.write(traceback.format_exc())
            raise
        

        
                        