#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 10414 2017-10-28 14:37:45Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-10-28 22:37:45 +0800 (Sat, 28 Oct 2017) $
# $Revision: 10414 $

from django.shortcuts import render_to_response

from Iuppiter.extension.views import jsonpCallback, view

from Theophrastus.Utility import _slugify
from Theophrastus.models import MailingList

@jsonpCallback(noPadding=True)
def getSlugName(request):
    """
    Get slug name.

    @param request Request instance.
    """
    title = request.GET.get('title', '')
    if title:
        return {'slug': _slugify(title)}
    else:
        return {}

@view('FeedComplete.html')
def feedComplete(request):
    """
    Redirect to this view when feed completed.

    If feed successfully, we will get a argument "post_id".
    Sample: post_id=100000187377979_135405309958471

    @param request Request instance.
    """
    postId = request.GET.get('post_id', '')
    return {'postId': postId}

@jsonpCallback()
def getMailingListInfo(request):
    """
    Get MailingList information.

    @param request Request instance.
    """
    mailingListId = request.GET.get('mailingList', '')
    newsletterIds = request.GET.get('newsletters', '')
    newsletterIds = newsletterIds.split('_')
    try:
        if mailingListId:
            mailingList = MailingList.objects.get(id=mailingListId)
            return {
                'subscribersCount': mailingList.subscribers_count(),
                'name': mailingList.name
            }
        elif newsletterIds:
            info = []
            for n in Newsletter.objects.filter(id__in=newsletterIds):
                mailingList = n.mailing_list
                info.append({
                    'subscribersCount': mailingList.subscribers_count(),
                    'name': n.title
                })

            return {'info': info}
    except Exception as e:
        pass
    return {'error': str(e)}

