#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 11720 2019-09-23 06:12:17Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-09-23 15:12:17 +0900 (週一, 23 九月 2019) $
# $Revision: 11720 $

from django.contrib import admin
from Iuno.ban.models import Keyword, Ban

class KeywordInline(admin.TabularInline):
    model = Keyword
    extra = 0

class BanAdmin(admin.ModelAdmin):
    model = Ban
    list_display = ['urlPattern']
    inlines = [KeywordInline,]
    
admin.site.register(Ban, BanAdmin)