#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Local.py 9439 2015-09-25 08:01:30Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 16:01:30 +0800 (Fri, 25 Sep 2015) $
# $Revision: 9439 $

import logging

logger = logging.getLogger(__name__)

from Iuno.cloud.backend import Local
from Iuno.cloud.logging.backend import BackendMixin

class Backend(Local.Backend, BackendMixin):

    def _getDefaultConfig(self):
        return {
            'SENTRY_DSN': 'threaded+http://',
            'HOST_OS': 'linux',
        }

    def getSentryInfo(self, preferred=None, config=None):
        domains = self.getDomains(preferred)
        for domain in domains:
            if self._checkHttp(domain):
                return self.domains[domain]

        return None
