#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: FreeCss.py 9934 2017-04-30 11:55:29Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-30 19:55:29 +0800 (週日, 30 四月 2017) $
# $Revision: 9934 $

import scrapy

from Downloader.items import DownloaderItem as Item

class FreeCssSpider(scrapy.Spider):
    name = "freecss"

    def start_requests(self):
        urls = ['http://www.free-css.com/free-css-templates',]
        for url in urls:
            print '-----Start download %s -----' % url
            yield scrapy.Request(url=url, callback=self.parse)
    
    def parse(self, response):
        urls = response.css('#showcase ul li figure a::attr(href)').extract()
       
        for url in urls:
            url = 'http://www.free-css.com' + url
            yield scrapy.Request(url=url, callback=self.parse_author)
        
        
        pages = response.css('.pagination li a')
        for page in pages:
            pageName = page.css('::text').extract()[0]
            if 'Older' in pageName:
                nextUrl = 'http://www.free-css.com' + \
                                           page.css('::attr(href)').extract()[0]
                print '-----Start download %s -----' % nextUrl
                yield scrapy.Request(url=nextUrl, callback=self.parse)
                break
        
                
    def parse_author(self, response):
        item = Item()
        url = response.css(".buttons .clear .dld a::attr(href)").extract()[0]
        url = 'http://www.free-css.com' + url
        
        # file
        item['downloadUrl'] = url   
        
        # data
        item["slug"] = response.url.split("/")[-1]
        
        item['title'] = response.css(
            "#content h1 span::text").extract_first(default=None)
        item["source"] = response.url
        item['previewUrl'] = 'http://www.free-css.com' + response.css(
            ".buttons .demo a::attr(href)"
            ).extract_first(default=None)
            
        item['license'] = 'http://www.free-css.com' + response.css(
            ".licence a::attr(href)").extract_first(default=None)
            
        item['dateCreate'] = response.css(
            ".added::text").extract_first(default=None)
            
        item['description'] = None
        
        item['description2'] = response.css(
            ".fl_right").extract_first(default=None)
        
        item['category'] = response.css(
            ".tags ul li a::text").extract()
            
        item['author'] = response.css(
            ".authorname strong::text"
            ).extract_first(default=None)
            
        # image
        item['imageUrl'] = response.css(
            ".fl_left img::attr(src)"
            ).extract()
            
        item['imageUrl'] = \
            ["http://www.free-css.com" + img for img in item['imageUrl']]
        
        yield item
        