import os
import zipfile
import argparse
import json
import hashlib

from PIL import Image

def unZip(fileName, dowmloadTo):
    try:
        jsonfile = open('./json/%s' % fileName)
        data = json.load(jsonfile)
        jsonfile.close()
        zipPath = './templates/%s' % data['filePath']
        
        dstPath = os.path.join(dowmloadTo, data['slug'])
        
        data['upc'] = hashlib.md5(data['title'] + data['source']).hexdigest()
        
        zip = zipfile.ZipFile(zipPath)
        zip.extractall(os.path.join(dstPath, "template"))
        zip.close()
        
        with open(os.path.join(dstPath, "info.json"), 'wb') as jf:
            line = json.dumps(data)
            jf.write(line)
        
        if data['imagePath']:
            for i, imgPath in enumerate(data['imagePath'], 1):
                img = Image.open(os.path.join('.', 'images', imgPath))
                if not os.path.exists(os.path.join(dstPath, 'images')):
                    os.mkdir(os.path.join(dstPath, 'images'))
                img.save(os.path.join(dstPath, 'images', "%d.png" % i), "PNG")
                img.close()
        
        print "    Successfully unzip %s to templates folder" % fileName      
    except Exception as e:
        with open('./UnzipError.txt', 'a+') as f:
            f.write(str(e))
            f.write(" from %s\n" % jsonfile)
        
if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Download free web templates')
    
    parser.add_argument('path', metavar='path', type=str,
                        help='destination path')
    
    dowmloadTo = parser.parse_args().path
    
    for file in os.listdir("./json"):
        unZip(file, dowmloadTo)