#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10219 2017-08-27 05:13:34Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-27 13:13:34 +0800 (週日, 27 八月 2017) $
# $Revision: 10219 $

from django.db import models
from django.utils import timezone
from jsonfield import JSONField

class Email(models.Model):
    email = models.EmailField()
    fromUrl = models.URLField()
    date = models.DateTimeField(
        auto_now_add=True)

    data = JSONField(null=True, blank=True, default={})
        
    def __unicode__(self):
        return u"%s From: %s (%s)" % (self.email, self.fromUrl, self.date)
