#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Settings.py 10932 2018-03-26 07:56:30Z Kevin $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $
# $Date: 2018-03-26 16:56:30 +0900 (週一, 26 三月 2018) $
# $Revision: 10932 $
#
# Contributors:
#  Jumann (original author)
#  Bear

from django import template
from django.template import Library
import re

register = Library()

@register.tag
def settings(parser, token):
    """
    Generate the value of the settings attribute if you have to get the
    attribute of the settings file.

    @param parser Template parser.
    @param token Current token.
    @return SettingsNode instance of class.
    """
    try:
        # Splitting by None == splitting by spaces.
        tagName, arg = token.contents.split(None, 1)
    except ValueError:
        raise template.TemplateSyntaxError(
            "%r tag requires arguments" % token.contents.split()[0]
        )
    m = re.search(r'(.*?) as (\w+)', arg)
    if not m:
        raise template.TemplateSyntaxError(
               "%r tag had invalid arguments" % tagName)
    settingsVar, varName = m.groups()
    return SettingsNode(settingsVar, varName)

import six

if six.PY2:
    from django.utils.encoding import smart_unicode as smart_text
else:
    from django.utils.encoding import smart_text

from Iuppiter.Configure import settings as projectSettings

class SettingsNode(template.Node):
    """
    Process how to render SettingsNode tag.
    """

    def __init__(self, arg, varName):
        """
        Constructor.

        @param arg The attribute of the settings file.
        """
        self.arg = arg
        self.varName = varName

    def render(self, context):
        """
        Render.
        
        @param context Context instance.
        @return To render page helper before current page render.
        """
        context[self.varName] = smart_text(
                                  getattr(projectSettings, self.arg))
        return ''
