#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: testall.py 11265 2018-11-23 05:42:44Z Kevin $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-23 14:42:44 +0900 (週五, 23 十一月 2018) $
# $Revision: 11265 $

import sys

from django.core.management.base import BaseCommand

class Command(BaseCommand):
    help = 'Run all the tests in the package'

    def add_arguments(self, parser):
        parser.add_argument('-c',
            '--coverage',
            dest='coverage',
            default=False,
            action='store_true',
            help='Run coverage to test code quality.',
        )
        parser.add_argument('-p',
            '--pylint',
            dest='pylint',
            default=False,
            action='store_true',
            help='Run pylint to test code quality.',
        )
        parser.add_argument('-j',
            '--jslint',
            dest='jslint',
            default=False,
            action='store_true',
            help='Run jslint to test code quality.',
        )
        parser.add_argument('-w',
            '--view',
            dest='view',
            default=False,
            action='store_true',
            help='View test report after running test cases.',
        )

    def handle(self, app='', *args, **options):

        from Iuppiter.test.Runner import TestRunner

        if '-w' in sys.argv:
            wIndex = sys.argv.index('-w')
            sys.argv[wIndex] = '-v'

        TestRunner('.').run()

        import os

        from Iuppiter.Util import colored, cprint

        packageName = os.path.basename(os.path.abspath(os.path.curdir))

        print(("Running tests in %s finished!!!"
              % (colored(packageName, 'yellow', attrs=['bold']))))
