#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: EncodingTest.py 11267 2018-11-23 08:23:13Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-23 17:23:13 +0900 (週五, 23 十一月 2018) $
# $Revision: 11267 $
"""
Test all encoding functions.
"""
import locale

from Iuppiter import test

test.chdirToRootDir()

import unittest

class EncodingTest(unittest.TestCase):
    """
    Test case for Encoding.
    """

    def testUtf8(self):
        """
        Test for utf8 function.
        """
        from Iuppiter.Encoding import utf8

        if locale.getlocale()[1] != 'cp950':
            try:
                locale.setlocale(locale.LC_ALL, ('cht', 'cp950'))
            except:
                pass

        msg = (
            b"\xa4@\xa6\xb8\xa5u\xaf\xe0\xa5\xce\xa4@\xad\xd3\xb3q\xb0T"
            b"\xba\xdd\xa6\xec\xa7} (\xb3q\xb0T\xa8\xf3\xa9w/\xba\xf4\xb8"
            b"\xf4\xa6\xec\xa7}/\xb3s\xb1\xb5\xb0\xf0)\xa1C"
        )
        msgAns = (
            b'\xe4\xb8\x80\xe6\xac\xa1\xe5\x8f\xaa\xe8\x83\xbd\xe7\x94\xa8'
            b'\xe4\xb8\x80\xe5\x80\x8b\xe9\x80\x9a\xe8\xa8\x8a\xe7\xab\xaf'
            b'\xe4\xbd\x8d\xe5\x9d\x80 (\xe9\x80\x9a\xe8\xa8\x8a\xe5\x8d\x94'
            b'\xe5\xae\x9a/\xe7\xb6\xb2\xe8\xb7\xaf\xe4\xbd\x8d\xe5\x9d\x80/'
            b'\xe9\x80\xa3\xe6\x8e\xa5\xe5\x9f\xa0)\xe3\x80\x82'
        )

        self.assertEqual(utf8(msg), (
            msgAns
        ))

        ans = u'道路'.encode('utf-8')
        cp950 = u'道路'.encode('cp950')
        gb2312 = u'道路'.encode('gb2312') # b'\xb5\xc0\xc2\xb7'

        gb2312w = u'本地可能'.encode('gb2312')
        gbAns = u'本地可能'.encode('utf8')

        self.assertEqual(utf8(cp950), ans)

        # #FIXME: It will convert to cp950 first then utf8. So in this case,
        #         we don't have any way to make it pass.
        self.assertNotEqual(utf8(gb2312), ans)

        self.assertEqual(utf8(gb2312w), gbAns)

    def test_unicode(self):
        """
        Test for _unicode function.
        """
        from Iuppiter.Encoding import _unicode

        if locale.getlocale()[1] != 'cp950':
            try:
                locale.setlocale(locale.LC_ALL, ('cht', 'cp950'))
            except:
                pass

        # Simplified chinese.
        s = b'\xd0\xc7\xc6\xda\xc8\xfd'

        self.assertEqual(_unicode(s, encodings=['gb2312',]),
                         u'\u661f\u671f\u4e09')

        with self.assertRaises(UnicodeDecodeError):
            _unicode(s)


if __name__ == '__main__':
    unittest.main()
